<?php
$ver = '1.4';

$filelist = array(
#'ana.php|解析結果生成用ファイル|',
'calendar.php|カレンダー生成用ファイル|',
'info.php|ログ管理用ファイル|',
'load_setting.php|各種設定読み込み用ファイル|',
'navi.php|ナビゲーション生成用ファイル|',
'redirect.php|リダイレクト用ファイル|',
'select.php|指定ログ表示用ファイル|',
'setting.php|設定変更用ファイル|',
'w3a.php|解析ページ出力用ファイル|',
'writelog.php|ログ取得用ファイル|',
'js01.js|JavaScript各種|',
'jcode/|マルチバイト非対応環境用|',
'image/|画像各種|',
'list/|解析データ変換用リスト各種|',
);

function debug($data){
	print "<XMP>";
	print_r($data);
	print "</XMP>";
	exit;
}
?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
"http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>w3Analyzer 設置マニュアル＆チェッカー ver.<?php echo $ver; ?></title>
<script language="javascript" src="js01.js"></script>
<style type="text/css">
<!--
BODY {
	background-color: #FFFFFF;
	font-size: small;
	font-family: Verdana, Arial, "MS UI Gothic", Osaka, Helvetica, sans-serif;
	color: #333;
	line-height: 200%;
	letter-spacing: 0.1em;
}
.ok {
	color: #03F;
}
.ng {
	color: #F30;
}
.copy {
	font-size: 10px;
	text-align: center;
}
-->
</style>
</head>
<body>
<h3>w3Analyzer 設置マニュアル＆チェッカー ver.<?php echo $ver; ?></h3>
<hr size="1">
<h3>設置方法</h3>
<ol type="1">
<li>[inc / config.php]を開いて初期設定</li>
<li>[writelog.php]を開いて[$acc_path]の値を自分の環境に合わせて変更</li>
<li>[w3a]フォルダごとアップロード</li>
<li>[logs]フォルダのパーミッションを[707]または[777]に変更</li>
<li>[data]フォルダのパーミッションを[707]または[777]に変更</li>
<li>[logs]フォルダ内にファイルが<u>ある場合</u>（以前のログ）は[606]または[666]に変更</li>
<li>[data]フォルダ内のファイルを[606]または[666]に変更</li>
<li>必要に応じてw3a.phpにアクセス後、管理メニューから設定<br>
	※管理メニューは[inc/config.php]内の[$adm]の値を1に設定した時のみ表示されます。</li>
</ol>
<hr size="1">
<h3>設定チェッカー</h3>
空き容量&nbsp;：
<?php
if(disk_total_space("/") > 1000000000){
	echo round(disk_free_space("/")/1000000000,2)." GB"
		.'&nbsp;/&nbsp;'
		.round(disk_total_space("/")/1000000000,2)." GB";
}elseif(disk_total_space("/") > 1000000){
	echo round(disk_free_space("/")/1000000,2)." MB"
		.'&nbsp;/&nbsp;'
		.round(disk_total_space("/")/1000000,2)." MB";
}elseif(disk_total_space("/") > 1000){
	echo round(disk_free_space("/")/1000,2)." B"
		.'&nbsp;/&nbsp;'
		.round(disk_total_space("/")/1000,2)." B";
}else{
	echo disk_free_space("/")." Byte"
		.' / '
		.disk_total_space("/")." Byte";
}
?>
<ul>
<?php
//キャッシュクリア
clearstatcache();
//設定読み込み
include_once("./inc/config.php");
$filelist[] = $logdir.'|ログ保存用ディレクトリ|d';
$filelist[] = $datadir.'|設定保存用ディレクトリ|';
$filelist[] = $datadir.'act.txt|設定ファイル（解析項目）|f';
$filelist[] = $datadir.'ch_url.txt|設定ファイル（URL変換）|f';
$filelist[] = $datadir.'def_act.txt|設定ファイル（初期アクション）|f';
$filelist[] = $datadir.'exclude_hosts.txt|設定ファイル（拒否リスト IP・HOST）|f';
$filelist[] = $datadir.'exclude_uas.txt|設定ファイル（拒否リスト ユーザーエージェント）|f';
$filelist[] = $datadir.'exclude_urls.txt|設定ファイル（拒否リスト URL）|f';
$filelist[] = $datadir.'skin.txt|設定ファイル（スキン指定）|f';
$filelist[] = $plugindir.'|プラグイン用ディレクトリ|';
$filelist[] = $icondir.'|アイコン各種|';
$filelist[] = $skindir.'|スキン用|';
//チェック
foreach($filelist as $v){
	list($name,$ex,$op) = explode('|', $v);
	$perm = "";
	//存在チェック
	if(file_exists($name)){
		$flg = 0;
		//パーミッション
		$perm = substr(sprintf('%o',fileperms($name)),-3);
		//書込みチェック
		if($op == "d" && !@mb_eregi("^(707|777)$", $perm)) $flg = 2;
		if($op == "f" && !@mb_eregi("^(606|666)$", $perm)) $flg = 3;
	}else{
		$flg = 1;
	}

	echo "<li>";
	echo (!$flg ? '<span class="ok">[OK]</span>' : '<span class="ng">[NG]</span>');
	echo "&nbsp;";
	echo $name;
	if($perm) echo "&nbsp;[".$perm."]";
	echo "&nbsp;";
	echo "（".$ex."）";
	switch ($flg) {
		case 1:
		    echo '<br><span class="ng">ファイルまたはディレクトリが存在しません。</span>';
			break;
		case 2:
		    echo '<br><span class="ng">パーミッションを変更してください。[707] or [777]</span>';
			break;
		case 3:
		    echo '<br><span class="ng">パーミッションを変更してください。[606] or [666]</span>';
			break;
	}
	echo "</li>\n";
}
?>
</ul>
<hr size="1">
<h3>機能制限</h3>
<ul>
<?php
$limit = "";
if(ini_get('safe_mode')){
	$limit .= "<li>";
	$limit .= '<span class="ng">[NG]</span>&nbsp;PHPセーフモード有効。';
	$limit .= '<br>ログ取得モードの選択が出来ません(解析速度が落ちます)';
	$limit .= "</li>\n";
}

if(!ini_get('allow_url_fopen')){
	$limit .= "<li>";
	$limit .= '<span class="ng">[NG]</span>&nbsp;allow_url_fopen無効。';
	$limit .= '<br>タイトルの自動取得が利用できません。';
	$limit .= "</li>\n";
}

if(!ini_get('short_open_tag')){
	$limit .= "<li>";
	$limit .= '<span class="ng">[NG]</span>&nbsp;short_open_tag無効。';
	$limit .= '<br>使用出来ません(もうちょっと待って下さい)';
	$limit .= "</li>\n";
}

if(!get_extension_funcs ("mbstring")){
	$limit .= "<li>";
	$limit .= '<span class="ng">[NG]</span>&nbsp;マルチバイト文字列関数無効。';
	$limit .= '<br>文字化け等のバグが発生するかもしれません。';
	$limit .= "</li>\n";
}

if(!$limit){
	$limit .= "<li>";
	$limit .= '<span class="ok">[OK]</span>&nbsp;機能制限は、ありません。';
	$limit .= "</li>\n";
}
echo $limit;
?>
</ul>
<hr size="1">
<h3>設置タグ</h3>
<ul>
<li>
for PHP<br><font color="#008800"><b>
<?php
echo '&lt;?php @include_once("'.dirname(__FILE__).'/writelog.php"); ?&gt;';
?>
</b></font>
</li>
<li>
for PHP with TITLE　（※タイトルが取得できない場合など）<br><font color="#008800"><b>
<?php
echo '&lt;?php $w3a_send_title="[ページタイトル]";@include_once("'.dirname(__FILE__).'/writelog.php"); ?&gt;';
?>
</b></font>
</li>
<li>
for JavaScript And Image <br><font color="#008800"><b>
&lt;script type="text/javascript"&gt;<br>
<?php
$httph = isset($_SERVER['HTTPS']) ? 'https://' : 'http://';
$httpd = isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : $_SERVER['SERVER_NAME'];
$httpp = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : $_SERVER['SCRIPT_NAME'];
$installpath = str_replace("check.php", "", $httph.$httpd.$httpp);
echo "&lt;!--<br>";
echo '$r=encodeURIComponent(document.referrer);<br>';
echo '$t=encodeURIComponent(document.title);<br>';
echo "document.write('&lt;img src=\"{$installpath}writelog.php?ref='".'+$r+'."'&pttl='".'+$t+'."'\" width=\"1\" height=\"1\" &gt;');<br>";
echo "//--&gt;<br>";
echo "&lt;/script&gt;<br>";
echo "&lt;noscript&gt;";
echo "&lt;img src=\"{$installpath}writelog.php?ref=".'" alt="" &gt;';
echo "&lt;/noscript&gt;<br>";
?>
</b></font>
</li>

</ul>
<hr size="1">
<h3>サポート</h3>
<ul>
<li>正常に設置できましたか？出来ない場合は掲示板へどうぞ</li>
<li>環境(サーバー名・PHPバージョン等)、w3Analyzerバージョン、エラー内容など、あるとサポートがスムーズにいくカモしれません。</li>
<li><a href="http://fmono.sub.jp/bbs/" target="_blank">オーサカPHP 掲示板へ</a></li>
<li>メールでも良いです:<a href="mailto:fmono@bs.sub.jp">fmono@bs.sub.jp</a></li>
<li><b>あなたのサーバー環境</b><br>
[PHP Version]&nbsp;<?php echo phpversion(); ?><br>
[Server Software]&nbsp;<?php $_SERVER["SERVER_SOFTWARE"]; ?>
</li>
</ul>
<hr size="1">
<h3>注意事項</h3>
<ul>
<li>writelog.phpの設定が間違っている方が多いように思います。</li>
<li>全ての環境で正常に作動するとは限りません。</li>
</ul>
<div class="copy">
<hr size="1">
&copy; OSAKA PHP * 2004-<?php echo date("Y"); ?>
</div>
</body>
</html>
