<?php
include_once("./inc/config.php");
include_once("./inc/function.php");

//ユーザ認証
include_once("./inc/userauth.php");

//マルチバイト関数設定
include_once("./inc/mb_check.php");

/*=========================================*/
/* 設定変更権限の確認                      */
/*=========================================*/
if(!$adm) die('Administrator Mode Off !!');

/*=========================================*/
/* スキン取得                              */
/*=========================================*/
$tmp_skin = @file($datadir."skin.txt");
$skin_file = $skindir.trim($tmp_skin[0])."/skin.html";

/*=========================================*/
/* PHP_SELF or SCRIPT_NAME                 */
/*=========================================*/
$sn = ($_SERVER['PHP_SELF'] ? $_SERVER['PHP_SELF'] : $_SERVER["SCRIPT_NAME"]);

/*=========================================*/
/* ファイルリスト取得                      */
/*=========================================*/
function getfilelist2($directory){
	if(!is_dir($directory)) return ;

	$files = array();
	$index = 0;
	if($dirh = @opendir($directory)){
		while (false !== ($filename = readdir($dirh))){
			if($filename == '.' || $filename == '..') continue;

			if(is_dir($directory.$filename)){
				$files[$filename] = getfilelist($directory.$filename);
			}
		}
	}
	asort($files);
	return $files;
}
/*=========================================*/
/* 全ファイル削除                          */
/*=========================================*/
function file_all_del($directory){
	if($dirh = @opendir($directory)){
		$f_count = 0;
		while (false !== ($filename = readdir($dirh))){
			if(is_dir($directory.$filename)) continue;
			if($filename == '.' || $filename == '..') continue;
			//DELETE
			@unlink($directory.'/'.$filename);
		}
		closedir($dirh);
	}
}


/*=========================================*/
/* ログ削除                                */
/*=========================================*/
if(isset($_POST["del_m"])){
	switch ($_POST["del_m"]) {
	    case "f":
			if($_POST["del_d"]) $_POST["del_d"] .= '/';
			$del_file = $logdir.$_POST["del_d"].$logpref.$_POST["del_f"].$logext;
	        break;
	    case "d":
			$del_file = $logdir.$_POST["del_f"];
	        break;
	    case "f_arr":
	        $del_file = $_POST["del_d"];
	        break;
	}

	$del_msg = "削除対象&nbsp;【&nbsp;<b>".$del_file."</b>&nbsp;】<hr size=1>"
				."結果：&nbsp;";
	if($_POST["del_m"] == "f_arr"){
		if($loglist = getfilelist($logdir)){
			$tmp_msg = null;
			foreach($loglist as $fn){
				if(!is_file($logdir.$fn)) continue;
				if(!@mb_eregi("^".$logpref.$_POST["del_d"], $fn)) continue;

				if(@unlink($logdir.$fn)){
					$tmp_msg .= "【".$fn."】&nbsp;削除しました。\n";
				}else{
					$tmp_msg .= "【".$fn."】&nbsp;削除できませんでした。\n";
				}
			}
			if($tmp_msg){
				$tmp_msg = trim($tmp_msg);
				$del_msg .= '<br />'.nl2br($tmp_msg);
			}else{
				$del_msg .= "削除するファイルが見つかりません。";
			}
		}else{
			$del_msg = "削除対象が見つかりません。";
		}
	}else{
		if(file_exists($del_file)){
			if(is_file($del_file)){
				if(@unlink($del_file)){
					$del_msg .= "削除しました。";
				}else{
					$del_msg .= "削除できませんでした。";
				}
			}elseif(is_dir($del_file)){
				file_all_del($del_file);
				if(@rmdir($del_file)){
					$del_msg .= "削除しました。";
				}else{
					$del_msg .= "削除できませんでした。";
				}
			}else{
				$del_msg .= "ファイルまたはディレクトリのパスが不正です。";
			}
		}else{
			$del_msg .= "ファイルが見つかりません。";
		}
	}
	$del_msg = '<div id="error">'.$del_msg.'</div>';
}else{
	$del_msg = "";
}

$w3a["DATA_VIEW"] = "";
$navi = null;
$filelist = array();
$file_size_total = 0;
if($log_type){
	// LOG TYPE 1
	$tmp_data = null;
	if($loglist = getfilelist($logdir)){
		unset($navi_list);
		foreach($loglist as $fn){
			if(!is_file($logdir.$fn)) continue;
			//navi
			$ym = substr(@mb_ereg_replace("($logpref|$logext)","",$fn), 0, -2);
			if(isset($navi_list[$ym])){
				$navi_list[$ym]++;
			}else{
				$navi_list[$ym] = 1;
			}
			if(isset($_GET["sel"])) if(!@mb_eregi("^".$logpref.$_GET["sel"], $fn)) continue;

			//日付取得
			$tmp_date = @mb_ereg_replace("($logpref|$logext)","",$fn);
			$tmp_ym = substr($tmp_date, 0, 6);
			$tmp_d = substr($tmp_date, -2);
			//リンク作成
			$file_link = '<a href="w3a.php?ym='.$tmp_ym.'&d='.$tmp_d.'" target="_top">'.$fn.'</a>';
			//削除ボタン（ファイル）
			$bt_del = null;
			if(isset($_GET['sel'])){
				$bt_del = '<form action="'.basename($sn).'?sel='.$_GET['sel'].'" method="POST" onSubmit="return check_del(\'ファイル【 '.$fn.' 】\')">'
						.'<input type="hidden" name="del_d" value="">'
						.'<input type="hidden" name="del_f" value="'.$tmp_date.'">'
						.'<input type="hidden" name="del_m" value="f">'
						.'<input type="submit" value="　ファイル削除　">'
						.'</form>';
			}
			$file_size = filesize($logdir.$fn);
			$file_size_total = $file_size_total + $file_size;
			if($file_size > 1000000000){
				$file_size = round($file_size/1000000000,2)." GB";
			}elseif($file_size > 1000000){
				$file_size = round($file_size/1000000,2)." MB";
			}elseif($file_size > 1000){
				$file_size = round($file_size/1000,2)." KB";
			}else{
				$file_size .= " Byte";
			}
			$tmp_data .= '<tr>'."\n";
			$tmp_data .= '<td width="150">'.set_img("image/report.gif").'&nbsp;'.$file_link.'</td>'."\n";
			$tmp_data .= '<td width="100">'.$file_size.'</td>'."\n";
			$tmp_data .= '<td width="150">'.date("Y/m/d H:i:s", filemtime($logdir.$fn)).'</td>'."\n";
			$tmp_data .= '<td width="150" align="center">'.$bt_del.'</td>'."\n";
			$tmp_data .= '</tr>'."\n";
		}


		//navi
		foreach($navi_list as $k => $v){
			$navi .= '<li><a href="'.basename($sn).'?sel='.$k.'">'
					.substr($k, 0, 4)."年".substr($k, 4, 5).'月 ('.$v.')'
					.'</a></li>'."\n";
		}
	}else{
		$w3a["DATA_VIEW"] = '<div id="error">ログファイル一覧の取得に失敗しました。</div>';
	}

	//出力
	if(isset($_GET['sel']) && isset($navi_list[$_GET['sel']]) && $tmp_data != ""){
		//削除ボタン（月）
		$bt_del = null;
		$bt_del = '<form action="'.basename($sn).'?sel='.$_GET['sel'].'" method="POST" onSubmit="return check_del(\'【 '.substr($_GET['sel'], 0, 4)."年".substr($_GET['sel'], 4, 5).'月'.' 】\')">'
				.'<input type="hidden" name="del_d" value="'.$_GET['sel'].'">'
				.'<input type="hidden" name="del_f" value="">'
				.'<input type="hidden" name="del_m" value="f_arr">'
				.'<input type="submit" value="当月のログ削除">'
				.'</form>';
		//月合計
		if($file_size_total > 1000000000){
			$file_size_total = round($file_size_total/1000000000,2)." GB";
		}elseif($file_size_total > 1000000){
			$file_size_total = round($file_size_total/1000000,2)." MB";
		}elseif($file_size_total > 1000){
			$file_size_total = round($file_size_total/1000,2)." KB";
		}else{
			$file_size_total .= " Byte";
		}
		$tmp_data .= '<tr>'."\n";
		$tmp_data .= '<td colspan="4" class="bg_total" align="right">合計サイズ：&nbsp;<b>'.$file_size_total.'</b></td>'."\n";
		$tmp_data .= '</tr>'."\n";
		//メイン
		$w3a["DATA_VIEW"] .= '<tr>'."\n"
				.'<th width="150">年月</th>'."\n"
				.'<th colspan="2">ファイル数</th>'."\n"
				.'<th width="150">削除</th>'."\n"
				.'</tr>'."\n"
				//ディレクトリデータ
				.'<tr>'."\n"
				.'<td width="150">'.set_img("image/folder.gif").'&nbsp;'
				.substr($_GET['sel'], 0, 4)."年".substr($_GET['sel'], 4, 5).'月'
				.'</td>'."\n"
				.'<td colspan="2">'.$navi_list[$_GET['sel']].'</td>'."\n"
				.'<td width="150" align="center">'.$bt_del.'</td>'."\n"
				.'</tr>'."\n"
				//ファイル用ヘッダ
				.'<tr>'."\n"
				.'<th width="150">ファイル名</th>'."\n"
				.'<th width="100">サイズ</th>'."\n"
				.'<th width="150">最終更新日</th>'."\n"
				.'<th width="150">削除</th>'."\n"
				.'</tr>'."\n"
				.$tmp_data;

		$w3a["DATA_VIEW"] = '<br><noscript><div id="error">※JavaScriptをOFFにすると削除時の確認はありませんので注意してください。</div><br></noscript>'
				.'<table border="0" cellspacing="3" cellpadding="3">'."\n"
				.$w3a["DATA_VIEW"]
				.'</table>'."\n";
	}elseif(isset($_GET['sel'])){
		$w3a["DATA_VIEW"] = '<div id="error">ログデータが見つかりません。</div>';
	}else{
		$w3a["DATA_VIEW"] = '<div id="error">ファイルリストから表示する年月を選択して下さい。</div>';
	}

}else{
	// LOG TYPE 0
	if($dirlist = getfilelist2($logdir)){
		krsort($dirlist);
		foreach($dirlist as $dir_name => $filelist){
			//navi
			$navi .= '<li><a href="'.basename($sn).'?sel='.$dir_name.'">'
					.$dir_name.' ('.count($filelist).')'
					.'</a></li>'."\n";

			if(!isset($_GET['sel']) || $dir_name != $_GET['sel']) continue;

			//削除ボタン（ディレクトリ）
			$bt_del = '<form action="'.basename($sn).'?sel='.$_GET['sel'].'" method="POST" onSubmit="return check_del(\'ディレクトリ【 '.$dir_name.' 】\')">'
					.'<input type="hidden" name="del_d" value="">'
					.'<input type="hidden" name="del_f" value="'.$_GET['sel'].'">'
					.'<input type="hidden" name="del_m" value="d">'
					.'<input type="submit" value="ディレクトリ削除">'
					.'</form>';

			$w3a["DATA_VIEW"] .= '<tr>'."\n"
					.'<th width="150">ディレクトリ名</th>'."\n"
					.'<th colspan="2">ファイル数</th>'."\n"
					.'<th width="150">削除</th>'."\n"
					.'</tr>'."\n"
					//ディレクトリデータ
					.'<tr>'."\n"
					.'<td width="150">'.set_img("image/folder.gif").'&nbsp;'.$dir_name.'</td>'."\n"
					.'<td colspan="2">'.count($filelist).'</td>'."\n"
					.'<td width="150" align="center">'.$bt_del.'</td>'."\n"
					.'</tr>'."\n"
					//ファイル用ヘッダ
					.'<tr>'."\n"
					.'<th width="150">ファイル名</th>'."\n"
					.'<th width="100">サイズ</th>'."\n"
					.'<th width="150">最終更新日</th>'."\n"
					.'<th width="150">削除</th>'."\n"
					.'</tr>'."\n";
			foreach($filelist as $k => $v){
				$filename = $logdir.$dir_name.'/'.$v;
				if(file_exists($filename)){
					//日付取得
					$tmp_d = @mb_ereg_replace("($logpref|$logext)","",$v);
					//リンク作成
					$file_link = '<a href="w3a.php?ym='.$dir_name.'&d='.$tmp_d.'" target="_top">'.$v.'</a>';
					//削除ボタン（ファイル）
					$bt_del = '<form action="'.basename($sn).'?sel='.$_GET['sel'].'" method="POST" onSubmit="return check_del(\'ファイル【 '.$v.' 】\')">'
							.'<input type="hidden" name="del_d" value="'.$dir_name.'">'
							.'<input type="hidden" name="del_f" value="'.$tmp_d.'">'
							.'<input type="hidden" name="del_m" value="f">'
							.'<input type="submit" value="　ファイル削除　">'
							.'</form>';

					$file_size = filesize($filename);
					$file_size_total = $file_size_total + $file_size;
					if($file_size > 1000000000){
						$file_size = round($file_size/1000000000,2)." GB";
					}elseif($file_size > 1000000){
						$file_size = round($file_size/1000000,2)." MB";
					}elseif($file_size > 1000){
						$file_size = round($file_size/1000,2)." KB";
					}else{
						$file_size .= " Byte";
					}
					$w3a["DATA_VIEW"] .= '<tr>'."\n";
					$w3a["DATA_VIEW"] .= '<td width="150">'.set_img("image/report.gif").'&nbsp;'.$file_link.'</td>'."\n";
					$w3a["DATA_VIEW"] .= '<td width="100">'.$file_size.'</td>'."\n";
					$w3a["DATA_VIEW"] .= '<td width="150">'.date("Y/m/d H:i:s", filemtime($filename)).'</td>'."\n";
					$w3a["DATA_VIEW"] .= '<td width="150" align="center">'.$bt_del.'</td>'."\n";
					$w3a["DATA_VIEW"] .= '</tr>'."\n";
				}
			}
			if($file_size_total > 1000000000){
				$file_size_total = round($file_size_total/1000000000,2)." GB";
			}elseif($file_size_total > 1000000){
				$file_size_total = round($file_size_total/1000000,2)." MB";
			}elseif($file_size_total > 1000){
				$file_size_total = round($file_size_total/1000,2)." KB";
			}else{
				$file_size_total .= " Byte";
			}
			$w3a["DATA_VIEW"] .= '<tr>'."\n";
			$w3a["DATA_VIEW"] .= '<td colspan="4" class="bg_total" align="right">合計サイズ：&nbsp;<b>'.$file_size_total.'</b></td>'."\n";
			$w3a["DATA_VIEW"] .= '</tr>'."\n";

		}
		if($w3a["DATA_VIEW"] != ""){
			$w3a["DATA_VIEW"] = '<br><noscript><div id="error">※JavaScriptをOFFにすると削除時の確認はありませんので注意してください。</div><br></noscript>'
					.'<table border="0" cellspacing="3" cellpadding="3">'."\n"
					.$w3a["DATA_VIEW"]
					.'</table>'."\n";
		}elseif(isset($_GET['sel'])){
			$w3a["DATA_VIEW"] = '<div id="error">ログデータが見つかりません。</div>';
		}else{
			$w3a["DATA_VIEW"] = '<div id="error">ファイルリストから表示するディレクトリを選択して下さい。</div>';
		}
	}else{
		if(isset($_GET["sel"])){
			$w3a["DATA_VIEW"] = '<div id="error">ログファイルが見つかりません。</div>';
		}else{
			$w3a["DATA_VIEW"] = '<div id="error">ログファイル一覧の取得に失敗しました。</div>';
		}
	}
}

#-------------------------------------------------
#  COPYRIGHT(削除禁止)
#-------------------------------------------------
$w3a["COPYRIGHT"] = '&copy;&nbsp;w3Analyzer&nbsp;'.$version.'&nbsp;<a href="http://fmono.sub.jp/" target="_blank">OSAKA&nbsp;PHP</a>&nbsp;2004-'.date("Y");

#-------------------------------------------------
#  NAVI_LIST
#-------------------------------------------------
$reload = "info.php".(isset($_GET["sel"]) ? '?sel='.$_GET["sel"] : "");
$w3a["NAVI_LIST"] = <<<EOM
<ul>
<li class="list_title">ログ情報一覧</li>
<li><a href="$reload">データ更新</a></li>
<li><a href="w3a.php">戻る</a></li>
<li class="list_title">ファイルリスト</li>
$navi
</ul>
EOM;

#-------------------------------------------------
#  DATA_ACCESS
#-------------------------------------------------
$w3a["DATA_ACCESS"] = '<div class="title">ログ情報一覧</div>'
					.$del_msg;

echo read_skin($skin_file,$w3a);
exit;
?>
