<?php
/*=========================================*/
/* Ver.                                    */
/*=========================================*/
$version = '2.1.2';

/*=========================================*/
/* 設定読み込み                            */
/*=========================================*/
include_once("./inc/config.php");
include_once("./inc/function.php");
include_once("./inc/save_list.php");

//ユーザー認証
include_once("./inc/userauth.php");

//マルチバイト関数設定
include_once("./inc/mb_check.php");

/*=========================================*/
/* タイムアウト対策等                      */
/*=========================================*/
//header
header ("Content-Type: text/html; charset=utf-8");
//実行時間制限なし
@set_time_limit(0);
@ini_set("memory_limit","-1");
//256バイト空文字出力
//echo str_pad('',256);
//flush();
/*=========================================*/
/* 初期化 & 初期設定                       */
/*=========================================*/
//時差指定無かったらとりあえず日本時間
if(!isset($time_diff)) $time_diff = 9;
//データ用 初期化
$data = array();
//データ用（ユニーク） 初期化
$data_uniq = array();
//実行フラグ
define ("W3A", "run");
//リンク元ジャンプ用マーク
define ("JUMPMARK", "image/jump.gif");
//追跡用マーク
define ("TRACKMARK", "image/track.gif");
//パス指定用マーク
define ("SELPATHMARK", "image/sel_path.gif");
//ファイル名
define ("FILENAME", "w3a.php");
//処理時間計算用
define ("STIME", getmicrotime());

/*=========================================*/
/* 日の取得                                */
/*=========================================*/
if(isset($_GET["ym"])){
	$now_y = substr($_GET["ym"], 0, 4);
	$now_m = substr($_GET["ym"], 4, 2);
}else{
	$now_y = gmdate("Y", time()+$time_diff*3600);
	$now_m = gmdate("m", time()+$time_diff*3600);
}
if(!isset($_GET["d"])) $_GET["d"] = gmdate("d", time()+$time_diff*3600);

/*=========================================*/
/* 年月の取得                              */
/*=========================================*/
$ym = (isset($_GET["ym"]) ? $_GET["ym"] : gmdate("Ym", time()+$time_diff*3600));
$logfile = ($log_type ? $logdir : $logdir.$ym);

/*=========================================*/
/* アクション取得                          */
/*=========================================*/
if(isset($_GET["act"])){
	$act = $_GET["act"];
}else{
	$tmp_act = @file($datadir."def_act.txt");
	$act = trim($tmp_act[0]);
}

/*=========================================*/
/* スキン取得                              */
/*=========================================*/
$tmp_skin = @file($datadir."skin.txt");
$skin_file = $skindir.trim($tmp_skin[0])."/skin.html";

/*=========================================*/
/* 拒否リストの読み込み                    */
/*=========================================*/
$exclude_fn = $datadir."exclude_hosts.txt";
if(file_exists($exclude_fn)) $exclude["hosts"] = setting_read($exclude_fn);
$exclude_fn = $datadir."exclude_urls.txt";
if(file_exists($exclude_fn)) $exclude["urls"] = setting_read($exclude_fn);
$exclude_fn = $datadir."exclude_uas.txt";
if(file_exists($exclude_fn)) $exclude["uas"] = setting_read($exclude_fn);
unset($exclude_fn);

/*=========================================*/
/* ID変換リストの読み込み                  */
/*=========================================*/
$list_fn = $datadir."ch_id.txt";
$ch_id = array();
if(file_exists($list_fn)) $ch_id = setting_read($list_fn);
unset($list_fn);
if(is_array($ch_id)){
	foreach($ch_id as $k => $v){
		list($tmp["id"],$tmp["name"]) = explode("||",$v);
		unset($ch_id[$k]);
		$ch_id[$tmp["id"]] = $tmp["name"];
	}
}

/*=========================================*/
/* 例外(日付無視/月単位取得)読み込み       */
/*=========================================*/
$exception_fn = $plugindir."exception_act.txt";
if(file_exists($exception_fn)) $exception_act = setting_read($exception_fn);
unset($exception_fn);
$flg_exception_act = false;
if(inc_array($act,$exception_act) || $_GET["d"] == 'all') $flg_exception_act = true;

/*=========================================*/
/* データ読み込み                          */
/*=========================================*/
if($log_type){
	// LOG TYPE 1 SAFE_MODE
	if($flg_exception_act){
		$dataday = 1;
		$datayear = substr($ym,0,4);
		$datamonth = substr($ym,4,2);
		while(checkdate($datamonth,$dataday,$datayear)){
			$findname =  str_replace('\\','/',dirname(__FILE__)).'/'.$logdir.$logpref.$ym.sprintf("%02d", $dataday).$logext;
			//データ存在チェック
			if(file_exists($findname)){
				$loglist[] = $logpref.$ym.sprintf("%02d", $dataday).$logext;
			}
			$dataday++;
		}
	}elseif($_GET["d"] == '00'){
		$_GET["d"] = '01';
		$datayear = substr($ym,0,4);
		$datamonth = substr($ym,4,2);
		$mk = mktime(0,0,0,$datamonth+1,0,$datayear);
		$dataday = strftime("%d",$mk);
		while(checkdate($datamonth,$dataday,$datayear)){
			$findname =  str_replace('\\','/',dirname(__FILE__)).'/'.$logdir.$logpref.$ym.sprintf("%02d", $dataday).$logext;
			//データ存在チェック
			if(file_exists($findname)){
				$loglist[] = $logpref.$ym.sprintf("%02d", $dataday).$logext;
				$_GET["d"] = sprintf("%02d", $dataday);
				break;
			}
			$dataday--;
		}
	}else{
		$loglist[] = $logpref.$ym.$_GET["d"].$logext;
	}
}else{
	// LOG TYPE 0
	if($flg_exception_act){
		$fn = array();
		$fn = getfilelist($logfile);
		if($fn){
			foreach ($fn as $v) {
				$loglist[] = $v;
			}
		}
	}elseif($_GET["d"] == '00'){
		$fn = array();
		$fn = getfilelist($logfile);
		if(count($fn)){
			$_GET["d"] = @mb_ereg_replace("($logpref|$logext)","",max($fn));
			$loglist[] = max($fn);
		}else{
			$_GET["d"] = '01';
		}
	}else{
		$loglist[] = $logpref.$_GET["d"].$logext;
	}
}

if(isset($loglist)){
	//データナンバー初期化
	$data_no = 0;
	//一時データ初期化
//	unset($tmp_data);

	foreach ($loglist as $v) {
		$v = $logfile."/".$v;
//		if(is_file($v)){
//			$lines = file($v);
//			foreach ($lines as $line_num => $line) {
//				//データ展開
//				$str = trim($line);
		if($fn = @fopen($v,"r")){
			//データ展開
			while(!feof($fn)){
				$str = fgets($fn);
				$str = trim($str);
				if($str == "") continue;
				//データ分割
				list(
				$tmp_data["dt"],
				$tmp_data["path"],
				$tmp_data["remoteip"],
				$tmp_data["ref"],
				$tmp_data["useragent"],
				$tmp_data["title"],
				$tmp_data["id"],
				$tmp_data["vc"]
				) = explode("\t",$str);
				//日付取得
				if($tmp_data["dt"]){
					list(
					$tmp_data["day"],
					$tmp_data["week"],
					$tmp_data["hour"],
					$tmp_data["minute"],
					$tmp_data["sec"]
					) = explode(",",$tmp_data["dt"]);
				}

				//パス指定
				if(isset($_GET["p_sel"]) && isset($_GET["act"]) && !strstr($tmp_data["path"],$_GET["p_sel"]) && $_GET["act"] != "p_sel") continue;

				//データ修正
				if($tmp_data["ref"]){
					$tmp_data["ref"] = str_replace ("[m]", $_SERVER["HTTP_HOST"], $tmp_data["ref"]);
					if(!strstr($tmp_data["ref"], 'https://') && !strstr($tmp_data["ref"], 'http://')) $tmp_data["ref"] = 'http://'.$tmp_data["ref"];
					$tmp_data["ref"] = log_save_dec($log_save["ref"],$tmp_data["ref"]);
				}
				if($tmp_data["remoteip"]) $tmp_data["remoteip"] = log_save_dec($log_save["host"],$tmp_data["remoteip"]);
				if($tmp_data["useragent"]) $tmp_data["useragent"] = log_save_dec($log_save["ua"],$tmp_data["useragent"],1);
				if(isset($tmp_data["id"]) && isset($ch_id[$tmp_data["id"]])) $tmp_data["ch_id"] = $ch_id[$tmp_data["id"]];
				if(isset($tmp_data["title"]))  $tmp_data["title"] = stripcslashes($tmp_data["title"]);


				//過去バージョンログ用
				if(!$tmp_data["id"]) $tmp_data["id"] = $tmp_data["remoteip"];

				//除外処理
				if(inc_array($tmp_data["remoteip"],$exclude["hosts"])) continue;
				if(inc_array($tmp_data["ref"],$exclude["urls"])) continue;
				if(inc_array($tmp_data["useragent"],$exclude["uas"])) continue;

				//データ軽量化
				switch($act){
				case 'time':
					if(!isset($_GET["sel"]) || intval($tmp_data["hour"]) != intval($_GET["sel"])){
						unset($tmp_data["path"],$tmp_data["remoteip"],$tmp_data["ref"],$tmp_data["useragent"],$tmp_data["title"],$tmp_data["vc"],$tmp_data["day"],$tmp_data["week"],$tmp_data["minute"],$tmp_data["sec"]);
					}
					break;
				case 'day':
					if(!isset($_GET["sel"]) || intval($tmp_data["day"]) != intval($_GET["sel"])){
						unset($tmp_data["path"],$tmp_data["remoteip"],$tmp_data["ref"],$tmp_data["useragent"],$tmp_data["title"],$tmp_data["vc"],$tmp_data["week"],$tmp_data["hour"],$tmp_data["minute"],$tmp_data["sec"]);
					}
					break;
				case 'week':
					if(!isset($_GET["sel"]) || $tmp_data["week"] != $_GET["sel"]){
						unset($tmp_data["path"],$tmp_data["remoteip"],$tmp_data["ref"],$tmp_data["useragent"],$tmp_data["title"],$tmp_data["vc"],$tmp_data["day"],$tmp_data["hour"],$tmp_data["minute"],$tmp_data["sec"]);
					}
					break;
				case 'page':
				case 'p_sel':
					if(!isset($_GET["sel"])){
						unset($tmp_data["dt"],$tmp_data["remoteip"],$tmp_data["ref"],$tmp_data["useragent"],$tmp_data["vc"],$tmp_data["day"],$tmp_data["week"],$tmp_data["hour"],$tmp_data["minute"],$tmp_data["sec"]);
					}
					break;
				case 'ref':
					if(!isset($_GET["sel"])){
						unset($tmp_data["dt"],$tmp_data["path"],$tmp_data["remoteip"],$tmp_data["useragent"],$tmp_data["title"],$tmp_data["vc"],$tmp_data["day"],$tmp_data["week"],$tmp_data["hour"],$tmp_data["minute"],$tmp_data["sec"]);
					}
					break;
				case 'eng':
				case 'keyword':
					if(!isset($_GET["sel"]) || $tmp_data["ref"] == '' || @mb_ereg_replace("(https?|ftp)://([[:alnum:]\+\$\;\?\.%,!#~*:@&=_-]+)(/.*)","\\2",$tmp_data["ref"]) == $_SERVER["HTTP_HOST"]){
						unset($tmp_data["dt"],$tmp_data["path"],$tmp_data["remoteip"],$tmp_data["useragent"],$tmp_data["title"],$tmp_data["vc"],$tmp_data["day"],$tmp_data["week"],$tmp_data["hour"],$tmp_data["minute"],$tmp_data["sec"]);
					}
					break;
				case 'os':
				case 'browser':
					if(!isset($_GET["sel"])){
						unset($tmp_data["dt"],$tmp_data["path"],$tmp_data["remoteip"],$tmp_data["ref"],$tmp_data["title"],$tmp_data["vc"],$tmp_data["day"],$tmp_data["week"],$tmp_data["hour"],$tmp_data["minute"],$tmp_data["sec"]);
					}
					break;
				case 'host':
					if(!isset($_GET["sel"]) || $tmp_data["remoteip"] != $_GET["sel"]){
						unset($tmp_data["dt"],$tmp_data["path"],$tmp_data["ref"],$tmp_data["useragent"],$tmp_data["title"],$tmp_data["vc"],$tmp_data["day"],$tmp_data["week"],$tmp_data["hour"],$tmp_data["minute"],$tmp_data["sec"]);
					}
					break;
				case 'isp':
				case 'area':
					if(!isset($_GET["sel"])){
						unset($tmp_data["dt"],$tmp_data["path"],$tmp_data["ref"],$tmp_data["useragent"],$tmp_data["title"],$tmp_data["vc"],$tmp_data["day"],$tmp_data["week"],$tmp_data["hour"],$tmp_data["minute"],$tmp_data["sec"]);
					}
					break;
				case 'track':
				case 'id_name':
					if(!isset($_GET["sel"]) || $tmp_data["id"] != $_GET["sel"]){
						unset($tmp_data["dt"],$tmp_data["path"],$tmp_data["remoteip"],$tmp_data["ref"],$tmp_data["useragent"],$tmp_data["title"],$tmp_data["vc"],$tmp_data["day"],$tmp_data["week"],$tmp_data["hour"],$tmp_data["minute"],$tmp_data["sec"]);
					}
					break;
				case 'search':
					if(!isset($_POST["search_w"])){
						unset($tmp_data["dt"],$tmp_data["path"],$tmp_data["remoteip"],$tmp_data["ref"],$tmp_data["useragent"],$tmp_data["title"],$tmp_data["vc"],$tmp_data["day"],$tmp_data["week"],$tmp_data["hour"],$tmp_data["minute"],$tmp_data["sec"]);
					}
					break;
				default:
//					unset($tmp_data["dt"],$tmp_data["path"],$tmp_data["remoteip"],$tmp_data["ref"],$tmp_data["useragent"],$tmp_data["title"],$tmp_data["vc"],$tmp_data["day"],$tmp_data["week"],$tmp_data["hour"],$tmp_data["minute"],$tmp_data["sec"]);
					break;
				}
				//データ追加
				foreach($tmp_data as $k => $v){
					$tmp_data[$k] = trim($v);
				}
				$data[$data_no] = $tmp_data;
				$data_no++;
				if(isset($data_uniq[$tmp_data["id"]])){
					$data_uniq[$tmp_data["id"]]++;
				}else{
					$data_uniq[$tmp_data["id"]] = 1;
				}
				//一時データ初期化
				unset($tmp_data);
			}
			unset($lines);
		}
	}
	unset($loglist);
}
?>