<div class="title">ブラウザ</div>
<?php
/*=========================================*/
/* w3Analyzer Plug-in                      */
/*                                         */
/* ブラウザ解析 (UPDATE:07/08/25)          */
/*                                         */
/* オーサカPHP | http://fmono.sub.jp/      */
/*                                         */
/* Customized by Rin                       */
/*=========================================*/

/*=========================================*/
/* Function                                */
/*=========================================*/
//ブラウザ名,バージョン
function getuseragent($hua){
	global $browser_list;

	$browser = "";
	$browser_v = "";

	foreach($browser_list as $k => $v){
		unset($tmp);
		if(strstr($hua,$k)){
			list($tmp["name"], $tmp["var"]) = explode("||", $v);
			$browser = $tmp["name"];
			$browser_v = $tmp["var"];
			break;
		}
	}

	/*---Unknown---*/
	if(!$browser) $browser = 'Unknown Browser';
	if(!$browser_v) $browser_v = 'N/A';

	return 	array($browser,$browser_v);
}
//ソート用
function cmp($a , $b){
    if ($a["total"] == $b["total"]) return 0;
    return ($a["total"] > $b["total"]) ? -1 : 1;
}

/*=========================================*/
/* 初期化                                  */
/*=========================================*/
//ページ用配列 初期化
$main = array();
//アイコン用配列 初期化
$icon_list = array();

/*=========================================*/
/* リスト読み込み                          */
/*=========================================*/
//ブラウザ
$list_fn = "./list/browser.txt";
if(file_exists($list_fn)) $browser_list = setting_read($list_fn);
unset($list_fn);
//アイコン
$list_fn = "./list/icon.txt";
if(file_exists($list_fn)) $icon_list = setting_read($list_fn);
unset($list_fn);

/*=========================================*/
/* ブラウザリスト編集                      */
/*=========================================*/
if(is_array($browser_list)){
	foreach($browser_list as $k => $v){
		unset($tmp);
//		list($tmp["ua"], $tmp["name"], $tmp["var"]) = explode("||",$v);
//		if($tmp["name"] == "") $tmp["name"] = $tmp["ua"];
//		$browser_list[$tmp["ua"]] = $tmp["name"]."||".$tmp["var"];
		$tmp= explode("||",$v);
		if(!isset($tmp[1])) $tmp[1] = "";
		if(!isset($tmp[2])) $tmp[2] = "";
		if($tmp[1] == "") $tmp[1] = $tmp[0];
		$browser_list[$tmp[0]] = $tmp[1]."||".$tmp[2];
		unset($browser_list[$k],$tmp);
	}
}

/*=========================================*/
/* アイコンデータ編集                      */
/*=========================================*/
if(is_array($icon_list)){
	foreach($icon_list as $v){
		list($icon["name"],$icon["path"]) = explode("||",$v);
		//小文字にする
		$icon["name"] = strtolower($icon["name"]);
		$icon_path[$icon["name"]] = $icon["path"];
	}
}

/*=========================================*/
/* データ編集                              */
/*=========================================*/
if(is_array($data)){
	$main["total"] = 0;
	$userid = array();
	foreach($data as $v){
		if(isset($userid[$v["id"]][$v["useragent"]])) continue;
		$userid[$v["id"]][$v["useragent"]] = true;
		if($v["useragent"] == "") continue;
		$ua = getuseragent($v["useragent"]);
		if(isset($userid[$v["id"]][$ua[0]][$ua[1]])) continue;
		$userid[$v["id"]][$ua[0]][$ua[1]] = true;
		if(isset($main[$ua[0]][$ua[1]])){
			$main[$ua[0]][$ua[1]]++;
		}else{
			$main[$ua[0]][$ua[1]] = 1;
		}
		if(isset($main[$ua[0]]["total"])){
			$main[$ua[0]]["total"]++;
		}else{
			$main[$ua[0]]["total"] = 1;
		}
		$main["total"]++;
		//指定ログ取得
		if(isset($_GET["sel"]) && $ua[0] == $_GET["sel"]) $select[] = $v;
	}
	unset($data,$userid);
}
/*=========================================*/
/* 指定ログ                                */
/*=========================================*/
if(isset($_GET["sel"])) {
	mk_select($select);
	unset($select);
}else{
/*=========================================*/
/* ソート&最大値                           */
/*=========================================*/
	uasort($main , "cmp");
	//Unknown Browserを最後に移動
	if(isset($main["Unknown Browser"])){
		$tmp = $main["Unknown Browser"];
		unset($main["Unknown Browser"]);
		$main["Unknown Browser"] = $tmp;
	}

	$max_val = 0;
	foreach($main as $k => $v){
		if($k == "total") continue;
		unset($v["total"]);
		if($max_val < @max($v)) $max_val = @max($v);
	}

/*=========================================*/
/* メイン処理                              */
/*=========================================*/
	echo '<table>';
	echo '<tr>';
	echo '<th nowrap>ブラウザ</th>';
	echo '<th nowrap>バージョン</th>';
	echo '<th nowrap>ユニーク</th>';
	echo '<th nowrap>グラフ</th>';
	echo '</tr>';
	foreach($main as $k => $v){
		if($k == "total") continue;

		//ソート
		arsort($main[$k],SORT_NUMERIC);
		$tmp = "";
		$i = 0;
		foreach($main[$k] as $k2 => $v2){
			if($k2 == "total") continue;
			//link
			if($k == $tmp){
				$link = "&nbsp;";
			}else{
				//icon
				$icon = (isset($icon_path[strtolower($k)]) ? set_img($icondir.$icon_path[strtolower($k)],$k)."&nbsp;" : set_img($icondir."none.gif",$k)."&nbsp;");
				$link = $icon.sel_link(query_edit("sel",$k),$k);
			}
			$tmp = $k;

			echo '<tr id="bg_id'.$k.$i.'" onmouseover="chBG(\'bg_id'.$k.$i.'\', 1);" onmouseout="chBG(\'bg_id'.$k.$i.'\', 0);">';
			echo '<td>&nbsp;'.$link.'&nbsp;</td>';
			echo '<td>&nbsp;'.$k2.'&nbsp;</td>';
			echo '<td align="right">&nbsp;'.$v2.'&nbsp;</td>';
			echo '<td>&nbsp;'.mk_graph($v2,$main["total"],$max_val,2).'&nbsp;</td>';
			echo '</tr>'."\n";
			$i++;
		}
		//合計
		echo '<tr>';
		echo '<td class="bg_total">&nbsp;</td>';
		echo '<td class="bg_total" align="right">&nbsp;<b>合計：</b>&nbsp;</td>';
		echo '<td class="bg_total" align="right">&nbsp;<b>'.$main[$k]["total"].'</b>&nbsp;</td>';
		echo '<td class="bg_total">&nbsp;</td>';
		echo '</tr>'."\n";
	}
	echo '</table>';
	unset($main);
}
?>