<div class="title">検索エンジン</div>
<?php
/*=========================================*/
/* w3Analyzer Plug-in                      */
/*                                         */
/* 検索エンジン解析 (UPDATE:10/05/21)      */
/*                                         */
/* オーサカPHP | http://fmono.sub.jp/      */
/*                                         */
/* Customized by Rin                       */
/*=========================================*/

/*=========================================*/
/* 設定                                    */
/*=========================================*/
//検索キーワードにGoogleキャッシュの可能性のあるものを表示(0=>する ,1=>しない)
$google_cache = 0;

/*=========================================*/
/* Function                                */
/*=========================================*/
//検索キーワード取得
function get_keyword($query ,$query_key){
	global $google_cache;

	$keyword = "";
	foreach(explode("&", $query) as $tmp){
		unset($k,$v);
		list($k,$v) = explode("=", $tmp);
		$k = @mb_eregi_replace('amp;', '', $k);
		if($k == $query_key){
			if(trim($v) == "") continue;
			$v = urldecode($v);
			/*if(function_exists('mb_convert_encoding')){
				$v = @mb_convert_encoding($v, "eucJP-win" , "ISO-2022-JP-MS,eucJP-win,UTF-8,SJIS-win");
			}else{
				$v = jcode_convert_encoding($v,'euc-jp');
			}*/
			$v = str_replace('+', ' ', $v);
			if(function_exists('mb_ereg_replace')){
				$v = @mb_ereg_replace('　', ' ', $v);
			}else{
				$v = jstr_replace('　', ' ', $v);
			}
			$v = @mb_ereg_replace(" {2,}", " ", $v);
			$v = trim($v);

			//Googleキャッシュのスキップ
			if($google_cache && @mb_eregi('^cache:',$v)) continue;
			if($v == "") continue;

			$v = "［".@mb_ereg_replace(' ', '］&nbsp;［', $v)."］";

			$keyword = $v;
			break;
		}
	}

	return $keyword;
}
//ソート用
function cmp($a , $b){
    if ($a["total"] == $b["total"]) return 0;
    return ($a["total"] > $b["total"]) ? -1 : 1;
}

/*=========================================*/
/* 初期化                                  */
/*=========================================*/
//ページ用配列 初期化
$main = array();
//アイコン用配列 初期化
$icon_list = array();

/*=========================================*/
/* リスト読み込み                          */
/*=========================================*/
//検索エンジン
$list_fn = "./list/engine.txt";
if(file_exists($list_fn)) $engine_list = setting_read($list_fn);
unset($list_fn);
//アイコン
$list_fn = "./list/icon.txt";
if(file_exists($list_fn)) $icon_list = setting_read($list_fn);
unset($list_fn);

/*=========================================*/
/* アイコンデータ編集                      */
/*=========================================*/
if(is_array($icon_list)){
	foreach($icon_list as $v){
		list($icon["name"],$icon["path"]) = explode("||",$v);
		//小文字にする
		$icon["name"] = strtolower($icon["name"]);
		$icon_path[$icon["name"]] = $icon["path"];
	}
}

/*=========================================*/
/* データ編集                              */
/*=========================================*/
if(is_array($data)){
	foreach($data as $v){
		if(!isset($v["ref"])) continue;
		if($v["ref"] == "") continue;
		//URIを分割
		$url = parse_url($v["ref"]);
		if(!isset($url["query"])) continue;
		if(!isset($url["path"])) continue;
		foreach($engine_list as $list){
			unset($eng);
			list($eng["name"],$eng["q"],$eng["uri"]) = explode("||",$list);
			if(@mb_eregi("($eng[uri])",$url["host"])){
				//query修正
				if(@mb_eregi("=",$url["path"])){
					foreach (explode('/',$url["path"]) as $path_exp) {
						if(@mb_eregi("=",$path_exp)){
							if($url["query"]) $url["query"] .= "&";
							$url["query"] .= $path_exp;
						}
					}
				}
				//キーワード取得
				$keyword = get_keyword($url["query"] ,$eng["q"]);
				if($keyword != ""){
					if(isset($main[$eng["name"]]) && is_array($main[$eng["name"]])){
						if(!array_key_exists($keyword,$main[$eng["name"]])){
							$main[$eng["name"]][$keyword] = 1;
						}else{
							$main[$eng["name"]][$keyword]++;
						}
					}else{
						$main[$eng["name"]][$keyword] = 1;
					}
					if(isset($main[$eng["name"]]["total"])){
						$main[$eng["name"]]["total"]++;
					}else{
						$main[$eng["name"]]["total"] = 1;
					}
					if(isset($main["total"])){;
						$main["total"]++;
					}else{
						$main["total"] = 1;
					}
					//指定ログ取得
					if(isset($_GET["sel"]) && $eng["name"] == $_GET["sel"]) $select[] = $v;
					break;
				}
			}
		}
	}
	unset($data);
}
//ソート
uasort($main , "cmp");

/*=========================================*/
/* 指定ログ                                */
/*=========================================*/
if(isset($_GET["sel"])) {
	mk_select($select);
	unset($select);
}else{
/*=========================================*/
/* 最大値                                  */
/*=========================================*/
	$max_val = 0;
	foreach($main as $k => $v){
		if($k == "total") continue;
		unset($v["total"]);
		if($max_val < @max($v)) $max_val = @max($v);
	}

/*=========================================*/
/* メイン処理                              */
/*=========================================*/
	if(count($main)){
		echo '<table>';
		echo '<tr>';
		echo '<th nowrap>検索エンジン</th>';
		echo '<th nowrap>キーワード</th>';
		echo '<th nowrap>件数</th>';
		echo '<th nowrap>グラフ</th>';
		echo '</tr>';
		foreach($main as $k => $v){
			if($k == "total") continue;
			#unset($main[$k]["total"]);

			//ソート
			arsort($main[$k],SORT_NUMERIC);
			$tmp = "";
			$i = 0;
			foreach($main[$k] as $k2 => $v2){
				if($k2 == "total") continue;
				//link
				if($k == $tmp){
					$link = "&nbsp;";
				}else{
					//icon
					$icon = (isset($icon_path[strtolower($k)]) ? set_img($icondir.$icon_path[strtolower($k)],$k)."&nbsp;" : "");
					$link = $icon.sel_link(query_edit("sel",$k),$k);
				}
				$tmp = $k;

				echo '<tr id="bg_id'.$k.$i.'" onmouseover="chBG(\'bg_id'.$k.$i.'\', 1);" onmouseout="chBG(\'bg_id'.$k.$i.'\', 0);">';
				echo '<td>&nbsp;'.$link.'&nbsp;</td>';
				echo '<td>&nbsp;'.$k2.'&nbsp;</td>';
				echo '<td align="right">&nbsp;'.$v2.'&nbsp;</td>';
				echo '<td>&nbsp;'.mk_graph($v2,$main[$k]["total"],$max_val).'&nbsp;</td>';
				echo '</tr>'."\n";
				$i++;
			}
			//合計
			echo '<tr>';
			echo '<td class="bg_total">&nbsp;</td>';
			echo '<td class="bg_total" align="right">&nbsp;<b>合計：</b>&nbsp;</td>';
			echo '<td class="bg_total" align="right">&nbsp;<b>'.$main[$k]["total"].'</b>&nbsp;</td>';
			echo '<td class="bg_total">&nbsp;</td>';
			echo '</tr>'."\n";
		}
		echo '</table>';
		unset($main);
	}else{
		echo '<hr size="1"><div id="error">解析結果：0件</div>';
	}
}
?>