<div class="title">ISP</div>
<?php
/*=========================================*/
/* w3Analyzer Plug-in                      */
/*                                         */
/* ISP解析 (UPDATE:10/05/21)               */
/*                                         */
/* オーサカPHP | http://fmono.sub.jp/      */
/*                                         */
/* Customized by Rin                       */
/*=========================================*/

/*=========================================*/
/* 設定                                    */
/*=========================================*/
//リストにないドメインも表示(0=>しない ,1=>する)
$nolist = 1;

/*=========================================*/
/* 初期化                                  */
/*=========================================*/
//ページ用配列 初期化
$main = array();

/*=========================================*/
/* リスト読み込み                          */
/*=========================================*/
//検索エンジン
$list_fn = "./list/isp.txt";
if(file_exists($list_fn)) $isp_list = setting_read($list_fn);
unset($list_fn);

/*=========================================*/
/* ISPリスト編集                           */
/*=========================================*/
if($isp_list){
	foreach($isp_list as $lk => $lv){
		$isp = array();
		$isp = explode("||",$lv);
		if(isset($isp[0])){
			$isp["domain"] = $isp[0];
		}
		if(isset($isp[1])){
			$isp["name"] = $isp[1];
		}
		if(isset($isp[2])){
			$isp["com"] = $isp[2];
		}
		unset($isp[0],$isp[1],$isp[2]);
		unset($isp_list[$lk]);
		if(isset($isp["com"])) $isp["name"] .= "||".$isp["com"];
		unset($isp["com"]);
		$isp_list[$lk] = $isp;
	}
	unset($isp);
}
function getDomainlv3($host='') {
	$domain = null;
//	if (ereg('([0-9]{1,3}\.){3}[0-9]{1,3}$', $host)) return;
	if (preg_match('/([0-9]{1,3}\.){3}[0-9]{1,3}$/', $host)) return;
	$isp = explode('.', $host);
	$isp = array_reverse($isp);
	if (preg_match("/^(org|com|net|biz)$/i", $isp[0])) {
	   if(isset($isp[2])) $domain = '.';
	   $domain .= $isp[1].'.'.$isp[0];
	} else {
		// 適当ドメインレベル判定
		if(isset($isp[3])){
			if(preg_match("/^(city|vill|town)$/i", $isp[3])) {
	           if(isset($isp[4])) $domain = '.';
				$domain .= $isp[3].'.'.$isp[2].".";
			}
		}

		if(isset($isp[1]) && (strlen($isp[1]) == 2 || preg_match("/^(org|com|net|biz)$/i", $isp[1]))) {
			if(isset($isp[3])) $domain = '.';
			$domain .= $isp[2].'.';
		}else if(isset($isp[2]) && !$domain) {
			$domain = '.';
		}
		if(isset($isp[1])) $domain .= $isp[1].'.';
		$domain .= $isp[0];
   }
   return $domain;
}

/*=========================================*/
/* データ編集                              */
/*=========================================*/
if(is_array($data)){
	$userid = array();
	foreach($data as $v){
		if($v["remoteip"] == "") continue;
		if(!isset($userid[$v["id"]][$v["remoteip"]])){
			$userid[$v["id"]][$v["remoteip"]] = true;
			foreach($isp_list as $isp_k => $isp){
				if(strpos($v["remoteip"],$isp["domain"])!==false){
					if(!array_key_exists($isp["name"],$main)){
						$main[$isp["name"]] = 1;
					}else{
						$main[$isp["name"]]++;
					}
					break;
				}
			}
			if($nolist && !isset($main[$isp["name"]])){
				$ispname = getDomainlv3($v["remoteip"]);
				if($ispname){
					if(!array_key_exists($ispname,$main)){
						$main[$ispname] = 1;
					}else{
						$main[$ispname]++;
					}
					//指定ログ取得
					if(isset($_GET["sel"]) && $ispname == $_GET["sel"]) $select[] = $v;
				}
			}else{
				//指定ログ取得
				if(isset($_GET["sel"]) && @mb_ereg_replace('(.+)(\|\|)(.+)', "\\1", $isp["name"]) == $_GET["sel"]) $select[] = $v;
			}
		}
	}
	unset($data);
}
/*=========================================*/
/* 指定ログ                                */
/*=========================================*/
if(isset($_GET["sel"])) {
	mk_select($select);
	unset($select);
}else{
/*=========================================*/
/* メイン処理                              */
/*=========================================*/
	//ソート
	arsort($main ,SORT_NUMERIC);

	echo '<table>';
	echo '<tr>';
	echo '<th nowrap>ISP</th>';
	echo '<th nowrap>ユニーク</th>';
	echo '<th nowrap>グラフ</th>';
	echo '</tr>';
	$i = 0;
	foreach($main as $k => $v){
		$tmp["name"] = @mb_ereg_replace('(.+)(\|\|)(.+)', "\\1", $k);
//		if(ereg('(.+)(\|\|)(.+)',$k,$regs)){
		if(preg_match('/(.+)(\|\|)(.+)/',$k,$regs)){
			$tmp["com"] = "<br>&nbsp;(".$regs[3].")";
		}else{
			$tmp["com"] = "";
		}
		//link
		$link = sel_link(query_edit("sel",$tmp["name"]),$tmp["name"]).$tmp["com"];

		echo '<tr id="bg_id'.$i.'" onmouseover="chBG(\'bg_id'.$i.'\', 1);" onmouseout="chBG(\'bg_id'.$i.'\', 0);">';
		echo '<td>&nbsp;'.$link.'&nbsp;</td>';
		echo '<td align="right">&nbsp;<font color="#000044">'.$v.'</font>&nbsp;</td>';
		echo '<td>&nbsp;'.mk_graph($v,array_sum($main),max($main),2).'&nbsp;</td>';
		echo '</tr>';
		$i++;
	}
	//合計
	echo '<tr>';
	echo '<td class="bg_total" align="right">&nbsp;<b>合計：</b>&nbsp;</td>';
	echo '<td class="bg_total" align="right">&nbsp;<b>'.@array_sum($main).'</b>&nbsp;</td>';
	echo '<td class="bg_total">&nbsp;</td>';
	echo '</tr>'."\n";
	echo '</table>';
	unset($main);
}
?>