<div class="title">検索キーワード</div>
<?php
/*=========================================*/
/* w3Analyzer Plug-in                      */
/*                                         */
/* 検索キーワード解析 (UPDATE:10/05/21)    */
/*                                         */
/* オーサカPHP | http://fmono.sub.jp/      */
/*                                         */
/* Customized by Rin                       */
/*=========================================*/

/*=========================================*/
/* 設定                                    */
/*=========================================*/
//検索キーワードにGoogleキャッシュの可能性のあるものを表示(0=>する ,1=>しない)
$google_cache = 0;

/*=========================================*/
/* Function                                */
/*=========================================*/
//検索キーワード取得
function get_keyword($query ,$query_key){
	global $google_cache;

	$keyword = "";
	foreach(explode("&", $query) as $tmp){
		unset($k,$v);
		list($k,$v) = explode("=", $tmp);
		$k = @mb_eregi_replace('amp;', '', $k);
		if($k == $query_key){
			if(trim($v) == "") continue;
			$v = urldecode($v);
			/*if(function_exists('mb_convert_encoding')){
				$v = @mb_convert_encoding($v, "eucJP-win" , "ISO-2022-JP-MS,eucJP-win,UTF-8,SJIS-win");
			}else{
				$v = jcode_convert_encoding($v,'euc-jp');
			}*/
			$v = str_replace('+', ' ', $v);
			if(function_exists('mb_ereg_replace')){
				$v = @mb_ereg_replace('　', ' ', $v);
			}else{
				$v = jstr_replace('　', ' ', $v);
			}
			$v = @mb_ereg_replace(" {2,}", " ", $v);
			$v = trim($v);

			//Googleキャッシュのスキップ
			if($google_cache && @mb_eregi('^cache:',$v)) continue;
			if($v == "") continue;

			$v = "［".@mb_ereg_replace(' ', '］&nbsp;［', $v)."］";

			$keyword = $v;
			break;
		}
	}

	return $keyword;
}

/*=========================================*/
/* 初期化                                  */
/*=========================================*/
//ページ用配列 初期化
$main = array();

/*=========================================*/
/* リスト読み込み                          */
/*=========================================*/
//検索エンジン
$list_fn = "./list/engine.txt";
if(file_exists($list_fn)) $engine_list = setting_read($list_fn);
unset($list_fn);

/*=========================================*/
/* データ編集                              */
/*=========================================*/
if(is_array($data)){
	foreach($data as $v){
		if(!isset($v["ref"])) continue;
		if($v["ref"] == "") continue;
		//URIを分割
		$url = parse_url($v["ref"]);
		if(!isset($url["query"])) continue;
		if(!isset($url["path"])) continue;
		foreach($engine_list as $list){
			unset($eng);
			list($eng["name"],$eng["q"],$eng["uri"]) = explode("||",$list);
			if(@mb_eregi("($eng[uri])",$url["host"])){
				//query修正
				if(@mb_eregi("=",$url["path"])){
					foreach (explode('/',$url["path"]) as $path_exp) {
						if(@mb_eregi("=",$path_exp)){
							if($url["query"]) $url["query"] .= "&";
							$url["query"] .= $path_exp;
						}
					}
				}
				//キーワード取得
				$keyword = get_keyword($url["query"] ,$eng["q"]);
				if($keyword != ""){
					$keyword_edit = @mb_ereg_replace("(［|］)","",$keyword);
					foreach (explode('&nbsp;',$keyword_edit) as $search_key) {
						if(!array_key_exists($search_key,$main)){
							$main[$search_key] = 1;
						}else{
							$main[$search_key]++;
						}
					}

					//指定ログ取得
					if(isset($_GET["sel"])){
						if(@mb_eregi("［".urldecode($_GET["sel"])."］",$keyword)) $select[] = $v;
					}
					break;
				}
			}
		}
	}
	unset($data);
}
/*=========================================*/
/* 指定ログ                                */
/*=========================================*/
if(isset($_GET["sel"])) {
	mk_select($select);
	unset($select);
}else{
/*=========================================*/
/* メイン処理                              */
/*=========================================*/
	if(count($main)){
		//ソート
		arsort($main ,SORT_NUMERIC);

		echo '<table>';
		echo '<tr>';
		echo '<th nowrap>キーワード</th>';
		echo '<th nowrap>件数</th>';
		echo '<th nowrap>グラフ</th>';
		echo '</tr>';
		$i = 0;
		foreach($main as $k => $v){
			//link
			$link = sel_link(query_edit("sel",$k),$k);

			echo '<tr id="bg_id'.$i.'" onmouseover="chBG(\'bg_id'.$i.'\', 1);" onmouseout="chBG(\'bg_id'.$i.'\', 0);">';
			echo '<td>&nbsp;'.$link.'&nbsp;</td>';
			echo '<td align="right">&nbsp;<font color="#FF0000">'.$v.'</font>&nbsp;</td>';
			echo '<td>&nbsp;'.mk_graph($v,array_sum($main),max($main)).'&nbsp;</td>';
			echo '</tr>';
			$i++;
		}
		//合計
		echo '<tr>';
		echo '<td class="bg_total" align="right">&nbsp;<b>合計：</b>&nbsp;</td>';
		echo '<td class="bg_total" align="right">&nbsp;<b>'.@array_sum($main).'</b>&nbsp;</td>';
		echo '<td class="bg_total">&nbsp;</td>';
		echo '</tr>'."\n";
		echo '</table>';
		unset($main);
	}else{
		echo '<hr size="1"><div id="error">解析結果：0件</div>';
	}
}
?>