<div class="title">OS</div>
<?php
/*=========================================*/
/* w3Analyzer Plug-in                      */
/*                                         */
/* OS解析 (UPDATE:10/05/21)                */
/*                                         */
/* オーサカPHP | http://fmono.sub.jp/      */
/*                                         */
/* Customized by Rin                       */
/*=========================================*/

/*=========================================*/
/* Function                                */
/*=========================================*/
//OS,バージョン
function getuseragent($hua){
	global $os_list;
	$platform = null;
	$platform_v = null;
	//ロボット
	foreach($os_list["robot"] as $k => $v){
		if(strstr($hua,$k)){
			$platform = "Robot";
			break;
		}
	}
	if(!$platform){
		//簡易版モバイル
		if(strpos($hua, ';FOMA;')){
			$platform = 'DoCoMo';
			$platform_v = substr($hua, (strpos($hua, '(') + 1), (strpos($hua, ';') - strpos($hua, '(') -1));
		}else if(strpos($hua, 'DoCoMo/1.0') === 0 && strpos($hua, '/') >= 0){
			$platform = 'DoCoMo';
			$platform_v = substr($hua, 11, (strpos($hua, '/', 11) - 11));
		}else if(strpos($hua, 'DoCoMo/2.0') === 0 && strpos($hua, '(') >= 0){
			$platform = 'DoCoMo';
			$platform_v = substr($hua, 11, (strpos($hua, '(', 11) - 11));
		}else if(strpos($hua, 'KDDI-') === 0 && strpos($hua, 'UP.Browser') >= 0){
			$platform = 'KDDI';
			$platform_v = substr($hua, (strpos($hua, '-') + 1), (strpos($hua, ' ') - strpos($hua, '-') - 1));
		}else if(strpos($hua, '; KDDI-')){
			$platform = 'KDDI';
			$platform_v = substr($hua, (strpos($hua, '-') + 1), (strpos($hua, ')') - strpos($hua, '-') - 1));
		}else if(strpos($hua, '(KDDI-')){
			$platform = 'KDDI';
			$platform_v = substr($hua, (strpos($hua, '-') + 1), (strpos($hua, ';',strpos($hua, '-')) - strpos($hua, '-') - 1));
		}else if(strpos($hua, 'SoftBank/') === 0 && strpos($hua, 'NetFront') >= 0){
			$platform = 'SoftBank';
			$platform_v = substr($hua, 13, (strpos($hua, '/', 13) - 13));
		}else if(strpos($hua, ';SoftBank;')){
			$platform = 'SoftBank';
			$platform_v = substr($hua, (strpos($hua, '(') + 1), (strpos($hua, ';') - strpos($hua, '(') - 1));
		}else if(strpos($hua, 'Vodafone/1.0/') === 0){
			$platform = 'Vodafone';
			$platform_v = substr($hua, 13, (strpos($hua, '/', 13) - 13));
		}else if(strpos($hua, 'J-PHONE/') === 0){
			$platform = 'J-PHONE';
			$platform_v = substr($hua, 12, (strpos($hua, '/', 12) - 12));
		}else if(strpos($hua, '(jig browser') !== FALSE){
			$platform = 'jig browser';
			$platform_v = substr($hua, (strrpos($hua, ';') + 1), (strpos($hua, ')') - strrpos($hua, ';') - 1));
		}else if(strpos($hua, 'CE') !== false && strpos($hua, 'IEMobile') !== false){
			$platform = 'Windows CE';
			$platform_v = substr($hua, (strpos($hua, ') ') + 1));
		}else if(strpos($hua, 'CE') !== false && strpos($hua, 'Win') !== false){
			$platform = 'Windows';
			$platform_v = 'CE';
		}
	}
	if(!$platform){
		//Windows
//		if(ereg("Win",$hua)){
		if(preg_match("/Win/",$hua)){
			$platform = 'Windows';
			foreach($os_list["win"] as $k => $v){
				if(strstr($hua,$k)){
					$platform_v = $v;
					break;
				}
			}
		}
	}
	if(!$platform){
		//Macintosh
//		if(ereg("(Mac_PowerPC|Macintosh)",$hua)){
		if(preg_match("/(Mac_PowerPC|Macintosh)/",$hua)){
			$platform = 'Macintosh';
			foreach($os_list["mac"] as $k => $v){
				if(strstr($hua,$k)){
					$platform_v = $v;
					break;
				}
			}
		}
	}
	if(!$platform){
		//その他のOS
		foreach($os_list["other"] as $k => $v){
			if(strstr($hua,$k)){
				$platform = $v;
				break;
			}
		}
	}

	/*---Unknown---*/
	if(!$platform) $platform = 'Unknown OS';
	if(!$platform_v) $platform_v = 'N/A';

	return 	array($platform,$platform_v);
}
//ソート用
function cmp($a , $b){
    if ($a["total"] == $b["total"]) return 0;
    return ($a["total"] > $b["total"]) ? -1 : 1;
}

/*=========================================*/
/* 初期化                                  */
/*=========================================*/
//ページ用配列 初期化
$main = array();
//アイコン用配列 初期化
$icon_list = array();

/*=========================================*/
/* リスト読み込み                          */
/*=========================================*/
//OS
$list_fn = "./list/os_win.txt";
if(file_exists($list_fn)) $os_list["win"] = setting_read($list_fn);
$list_fn = "./list/os_mac.txt";
if(file_exists($list_fn)) $os_list["mac"] = setting_read($list_fn);
$list_fn = "./list/os_other.txt";
if(file_exists($list_fn)) $os_list["other"] = setting_read($list_fn);
$list_fn = "./list/os_robot.txt";
if(file_exists($list_fn)) $os_list["robot"] = setting_read($list_fn);
unset($list_fn);
//アイコン
$list_fn = "./list/icon.txt";
if(file_exists($list_fn)) $icon_list = setting_read($list_fn);
unset($list_fn);

/*=========================================*/
/* OSリスト編集                            */
/*=========================================*/
if(is_array($os_list)){
	foreach($os_list as $k => $v){
		unset($tmp);
		foreach($v as $k2 => $v2){
//			list($tmp["var"],$tmp["name"]) = explode("||",$v2);
//			$os_list[$k][$tmp["var"]] = $tmp["name"];
			$tmp = explode("||",$v2);
			if(isset($tmp[1])){
				$os_list[$k][$tmp[0]] = $tmp[1];
			}else{
				$os_list[$k][$tmp[0]] = '';
			}
			unset($os_list[$k][$k2],$tmp);
		}
	}
}

/*=========================================*/
/* アイコンデータ編集                      */
/*=========================================*/
foreach($icon_list as $v){
	list($icon["name"],$icon["path"]) = explode("||",$v);
	//小文字にする
	$icon["name"] = strtolower($icon["name"]);
	$icon_path[$icon["name"]] = $icon["path"];
}

/*=========================================*/
/* データ編集                              */
/*=========================================*/
if(is_array($data)){
	$main["total"] = 0;
	$userid = array();
	foreach($data as $v){
		if($v["useragent"] == "") continue;
		if(isset($userid[$v["id"]][$v["useragent"]])) continue;
		$userid[$v["id"]][$v["useragent"]] = true;
		$ua = getuseragent($v["useragent"]);
		if(isset($userid[$v["id"]][$ua[0]][$ua[1]])) continue;
		$userid[$v["id"]][$ua[0]][$ua[1]] = true;
		if(!array_key_exists($ua[0],$main)){
			$main[$ua[0]]["total"] = 1;
		}else{
			$main[$ua[0]]["total"]++;
		}
		if(isset($main[$ua[0]][$ua[1]])){
			$main[$ua[0]][$ua[1]]++;
		}else{
			$main[$ua[0]][$ua[1]] = 1;
		}
		$main["total"]++;
		//指定ログ取得
		if(isset($_GET["sel"]) && $ua[0] == $_GET["sel"]) $select[] = $v;
	}
	unset($data,$userid);
}

/*=========================================*/
/* 指定ログ                                */
/*=========================================*/
if(isset($_GET["sel"])) {
	mk_select($select);
	unset($select);
}else{
/*=========================================*/
/* ソート&最大値                           */
/*=========================================*/
	uasort($main , "cmp");
	//Unknown OSを最後に移動
	if(isset($main["Unknown OS"])){
		$tmp = $main["Unknown OS"];
		unset($main["Unknown OS"]);
		$main["Unknown OS"] = $tmp;
	}

	$max_val = 0;
	foreach($main as $k => $v){
		if($k == "total") continue;
		unset($v["total"]);
		if($max_val < @max($v)) $max_val = @max($v);
	}

/*=========================================*/
/* メイン処理                              */
/*=========================================*/
	echo '<table>';
	echo '<tr>';
	echo '<th nowrap>OS</th>';
	echo '<th nowrap>バージョン</th>';
	echo '<th nowrap>ユニーク</th>';
	echo '<th nowrap>グラフ</th>';
	echo '</tr>';
	foreach($main as $k => $v){
		if($k == "total") continue;

		//ソート
		arsort($main[$k],SORT_NUMERIC);
		$tmp = "";
		$i = 0;
		foreach($main[$k] as $k2 => $v2){
			if($k2 == "total") continue;
			//link
			if($k == $tmp){
				$link = "&nbsp;";
			}else{
				//icon
				$icon = (isset($icon_path[strtolower($k)]) ? set_img($icondir.$icon_path[strtolower($k)],$k)."&nbsp;" : set_img($icondir."none.gif",$k)."&nbsp;");
				$link = $icon.sel_link(query_edit("sel",$k),$k);
			}
			$tmp = $k;

			echo '<tr id="bg_id'.$k.$i.'" onmouseover="chBG(\'bg_id'.$k.$i.'\', 1);" onmouseout="chBG(\'bg_id'.$k.$i.'\', 0);">';
			echo '<td>&nbsp;'.$link.'&nbsp;</td>';
			echo '<td>&nbsp;'.$k2.'&nbsp;</td>';
			echo '<td align="right">&nbsp;'.$v2.'&nbsp;</td>';
			echo '<td>&nbsp;'.mk_graph($v2,$main["total"],$max_val,2).'&nbsp;</td>';
			echo '</tr>'."\n";
			$i++;
		}
		//合計
		echo '<tr>';
		echo '<td class="bg_total">&nbsp;</td>';
		echo '<td class="bg_total" align="right">&nbsp;<b>合計：</b>&nbsp;</td>';
		echo '<td class="bg_total" align="right">&nbsp;<b>'.$main[$k]["total"].'</b>&nbsp;</td>';
		echo '<td class="bg_total">&nbsp;</td>';
		echo '</tr>'."\n";
	}
	echo '</table>';
	unset($main);
}
?>