<div class="title">リンク元</div>
<?php
/*=========================================*/
/* w3Analyzer Plug-in                      */
/*                                         */
/* リンク元解析 (UPDATE:10/05/21)          */
/*                                         */
/* オーサカPHP | http://fmono.sub.jp/      */
/*                                         */
/* Customized by Rin                       */
/*=========================================*/

/*=========================================*/
/* 設定                                    */
/*=========================================*/
//同一タイトルをグループ化(0=>しない ,1=>する)
//グループ化したものはリダイレクト不可
$title_group = 1;

//自ドメインの場合は対象外
$mydomain = 1;

/*=========================================*/
/* 初期化                                  */
/*=========================================*/
//ページ用配列 初期化
$main = array();

/*=========================================*/
/* リスト読み込み                          */
/*=========================================*/
//タイトル変換
$list_fn = "./data/ch_url.txt";
if(file_exists($list_fn)) $ch_url = setting_read($list_fn);
unset($list_fn);

/*=========================================*/
/* タイトル変換データ編集                  */
/*=========================================*/
if(is_array($ch_url)){
	foreach($ch_url as $k => $v){
		list($tmp["url"],$tmp["title"]) = explode("||",$v);
		unset($ch_url[$k]);
		$ch_url[$tmp["url"]] = $tmp["title"];
	}
}

/*=========================================*/
/* データ編集                              */
/*=========================================*/
if(is_array($data)){
	foreach($data as $k => $v){
		//自サイト内リンク削除
		if($mydomain) if(@mb_ereg_replace("(https?|ftp)://([[:alnum:]\+\$\;\?\.%,!#~*:@&=_-]+)(/.*)","\\2",$v["ref"]) == $_SERVER["HTTP_HOST"]) continue;

		if($v["ref"] == ""){
			$v["ref"] = "(Direct or Bookmark)";
		}else{
			//クエリ削除
			$v["ref"] = @mb_ereg_replace("(.*)\?(.*)","\\1", $v["ref"]);
		}

		//URLタイトル変換(グループ化)
		if($title_group && is_array($ch_url)){
			foreach($ch_url as $url => $title){
				if(strstr($v["ref"] ,$url)) $v["ref"] = $title;
			}
		}

		//ユニークユーザ
		$uniqs[$v["ref"]][$v["id"]] = true;
		//アクセス数
		if(isset($main[$v["ref"]])){
			$main[$v["ref"]]++;
		}else{
			$main[$v["ref"]] = 1;
		}

		//指定ログ取得
		if(isset($_GET["sel"]) && $v["ref"] == $_GET["sel"]) $select[] = $data[$k];
	}
	unset($data);
}

/*=========================================*/
/* 指定ログ                                */
/*=========================================*/
if(isset($_GET["sel"])) {
	mk_select($select);
	unset($select);
}else{
	/*=========================================*/
	/* ユニークアクセス&最大値                 */
	/*=========================================*/
	$max_val = 0;
	unset($tmp);
	if(isset($uniqs)){
		foreach($uniqs as $k => $v){
			$tmp[$k] = count($uniqs[$k]);
			if($max_val < $main[$k]) $max_val = $main[$k];
		}
		$uniqs = $tmp;
	}
	//ソート
	arsort($main,SORT_NUMERIC);

	/*=========================================*/
	/* メイン処理                              */
	/*=========================================*/
	if(count($main)){
		echo '<table>';
		echo '<tr>';
		echo '<th nowrap>リンク元</th>';
		echo '<th nowrap>ユニーク</th>';
		echo '<th nowrap>件数</th>';
		echo '<th nowrap>グラフ</th>';
		echo '</tr>';
		foreach($main as $k => $v){
			//JUMP
			$flg_jump = true;
			if($k == '(Direct or Bookmark)') $flg_jump = false;
//			if(!ereg("(https?|ftp|news)(://[[:alnum:]\+\$\;\?\.%,!#~*/:@&=_-]+)",$k)) $flg_jump = false;
			if($flg_jump && !preg_match("/^(https?|ftp)(:\/\/[[:alnum:]\+\$\;\?\.%,!#~*:@&=_-]+)(\/.*)/i",$k)) $flg_jump = false;

			if($flg_jump){
				$jump = '<a href="redirect.php?redirect='.$k.'" target="_blank">'.set_img(JUMPMARK).'</a>&nbsp;';
			}else{
				$jump = "";
			}
			//ユニーク値
			$uniq = intval($uniqs[$k]);
			//URLタイトル変換(グループ化なし)
			$url_title = "";
			if(!$title_group && is_array($ch_url)){
				foreach($ch_url as $url => $title){
					if(strstr($k ,$url)){
						$url_title = $title."<br>&nbsp;";
						break;
					}
				}
			}
			//link
			$link = $url_title.sel_link(query_edit("sel",$k),str_cut($k));

			echo '<tr id="bg_id'.$k.'" onmouseover="chBG(\'bg_id'.$k.'\', 1);" onmouseout="chBG(\'bg_id'.$k.'\', 0);">';
			echo '<td>&nbsp;'.$jump.$link.'&nbsp;</td>';
			echo '<td align="right">&nbsp;<font color="#0000FF">'.$uniq.'</font>&nbsp;</td>';
			echo '<td align="right">&nbsp;<font color="#FF0000">'.$v.'</font>&nbsp;</td>';
			echo '<td>&nbsp;'.mk_graph2($v,$main,$uniq,$uniqs,$max_val).'&nbsp;</td>';
			echo '</tr>';

			flush();
		}
		echo '</table>';
		unset($mail);
	}else{
		echo '<hr size="1"><div id="error">解析結果：0件</div>';
	}
}
?>