<div class="title">ログ検索</div>
<?php
/*=========================================*/
/* w3Analyzer Plug-in                      */
/*                                         */
/* ログ検索 (UPDATE:09/07/30)              */
/*                                         */
/* オーサカPHP | http://fmono.sub.jp/      */
/*                                         */
/* Customized by Rin                       */
/*=========================================*/

/*=========================================*/
/* 設定                                    */
/*=========================================*/
//表示数制限(0=>制限なし)
$view_max = 200;

/*=========================================*/
/* Function                                */
/*=========================================*/
//ログ検索
function log_search($arr,$search_w,$search_op){
	//キーワード分割
	$keys = preg_split("/(　| )+/", $search_w);
	$finds = array();
	foreach($arr as $k => $v){
		foreach($keys as $key){
			if(strpos($v, $key) !== false){
				if(!isset($finds[$key])) $finds[$key] = TRUE;
				$arr[$k] = str_replace($key,"<b style=\"background-color: #FFFF00;\">$key</b>",$arr[$k]);
			}
		}
	}
	$find = TRUE;
	foreach($keys as $key){
		if(!isset($finds[$key])){
			$find = FALSE;
			break;
		}
	}
	if($find) return $arr;
}

/*=========================================*/
/* 検索フォーム                            */
/*=========================================*/
echo '<form action="'.FILENAME.query_edit("sel","DELETE").'" method="POST">';
$searchword = isset($_POST["search_w"]) ? $_POST["search_w"]:'';
echo '<input type="text" name="search_w" size="50" value="'.$searchword.'">&nbsp;';
echo '<select name="search_op">';
echo '<option value="or"'.($_POST["search_op"] != "and" ? " selected" : "").'>OR</option>';
echo '<option value="and"'.($_POST["search_op"] == "and" ? " selected" : "").'>AND</option>';
echo '</select>&nbsp;';
echo '<input type="submit" value="検索">';
echo '</form>';
echo '<br>';

/*=========================================*/
/* 初期化                                  */
/*=========================================*/
//配列 初期化
$main = array();
//表示用配列 初期化
$main_view = array();
//一致数
$view_no = 0;

/*=========================================*/
/* データ編集                              */
/*=========================================*/
if(is_array($data) && isset($_POST["search_w"]) && $_POST["search_w"] != ""){
	$searchword = /*@mb_convert_encoding(*/$_POST["search_w"];//, "eucJP-win" , "ISO-2022-JP-MS,eucJP-win,UTF-8,SJIS-win");
	foreach($data as $v){
		unset($tmp);
		if(!isset($_POST["search_op"])) $_POST["search_op"] = '';
		$tmp = log_search($v,$searchword,$_POST["search_op"]);
		if($tmp){
			if($view_max && count($main) < $view_max){
				$main[] = $v;
				$main_view[] = $tmp;
			}
			$view_no++;
		}
	}
	unset($data);
	unset($tmp);
}
/*=========================================*/
/* メイン処理                              */
/*=========================================*/
if(isset($_POST["search_w"]) && $_POST["search_w"] != "") echo 'ログ検索キーワード［&nbsp;<b>'.$_POST["search_w"].'</b>&nbsp;］<hr size="1">';
if($view_no){
	echo '<b>'.$view_no.'</b>件のログが見つかりました。<br><br>';
	if($view_max && $view_no > $view_max){
		echo '<div id="error">該当ログが多すぎます。'.$view_max.'件以上の表示は出来ません。</div>';
	}else{
		foreach($main as $k => $v){
			echo 'No.'.($k+1).'<br>';
			//表示データ生成
			echo '<table width="100%">';
			if(trim($v["dt"])) echo '<tr><td width="100">Date:</td><td>&nbsp;'.$now_y."/".$now_m."/".$main_view[$k]["day"].'('.$main_view[$k]["week"].')&nbsp;'.$main_view[$k]["hour"].':'.$main_view[$k]["minute"].':'.$main_view[$k]["sec"].'</td></tr>';
			if(trim($v["path"])){
				echo '<tr><td width="100">Path:</td><td>';
				if($v["title"] != "") echo "[&nbsp;".$main_view[$k]["title"]."&nbsp;]<br>";
				echo '&nbsp;'.$main_view[$k]["path"].'</td></tr>';
			}
			if(trim($v["remoteip"])){
				//link
				if($v["id"]){
					$id = (isset($v["ch_id"]) ? $v["ch_id"] : $v["id"]);
					$link = query_edit("act", "track");
					$link = query_edit("sel", $v["id"], $link);
					$link = '<a href="'.FILENAME.$link.'">'.set_img(TRACKMARK)."&nbsp;".$id.'</a><br>';
				}else{
					$link = "";
				}
				echo '<tr><td width="100">Host:</td><td>&nbsp;'.$link.$main_view[$k]["remoteip"].'</td></tr>';
			}
			if(trim($v["ref"])){
				$sel_ref = urldecode($main_view[$k]["ref"]);
				//EUC-JPにエンコード（一応、必要ないかも）
				/*if(function_exists("mb_convert_encoding")){
					$sel_ref = @mb_convert_encoding($sel_ref, "eucJP-win" , "ISO-2022-JP-MS,eucJP-win,UTF-8,SJIS-win");
				}else{
					$sel_ref = jcode_convert_encoding($sel_ref,'euc-jp');
				}*/
				$sel_ref = '<a href="redirect.php?redirect='.$v["ref"].'" target="_blank">'.set_img(JUMPMARK)."&nbsp;".$sel_ref.'</a>&nbsp;';
				echo '<tr><td width="100">Refererer:</td><td>&nbsp;'.$sel_ref.'</td></tr>';
			}
			if(trim($v["useragent"])) echo '<tr><td width="100">UserAgent:</td><td>&nbsp;'.$main_view[$k]["useragent"].'</td></tr>';
			echo "</table>";
			echo "<br>";
		}
	}
}elseif(isset($_POST["search_w"]) && $_POST["search_w"] != ""){
	echo '<div id="error">該当するログは見つかりませんでした。</div>';
}
?>