<?php
include_once("./inc/config.php");
include_once("./inc/function.php");

//ユーザ認証
include_once("./inc/userauth.php");

//マルチバイト関数設定
include_once("./inc/mb_check.php");

/*=========================================*/
/* 設定変更権限の確認                      */
/*=========================================*/
if(!$adm) die('Administrator Mode Off !!');

/*=========================================*/
/* Function                                */
/*=========================================*/
//更新
function regist($updata, $filename){
	//クォートされた文字列削除
	$updata = stripslashes($updata);
	//改行統一
	$updata = str_replace( "\r\n",  "\r", $updata);
	$updata = str_replace( "\r",  "\n", $updata);

	foreach(explode("\n", $updata) as $k => $v){
		$v = trim($v);
		if($v == "") continue;
		$arr_updata[$k] = $v."\n";
	}

	//ログ生成
	if($fp = fopen($filename, "w")){
		flock($fp, 2);
		if(is_array($arr_updata)){
			foreach ($arr_updata as $v) {
				fputs($fp,$v);
			}
		}else{
			fputs($fp,$arr_updata);
		}
		flock($fp, 3);
		fclose($fp);
		return TRUE;
	}else{
		return FALSE;
	}
}

/*=========================================*/
/* スキン取得                              */
/*=========================================*/
$tmp_skin = @file($datadir."skin.txt");
$skin_file = $skindir.trim($tmp_skin[0])."/skin.html";

/*=========================================*/
/* PHP_SELF or SCRIPT_NAME                 */
/*=========================================*/
$sn = ($_SERVER['PHP_SELF'] ? $_SERVER['PHP_SELF'] : $_SERVER["SCRIPT_NAME"]);

/*=========================================*/
/* データ更新                              */
/*=========================================*/
if(isset($_POST["mode"])){
	//ファイル名
	$filename = $datadir.$_POST["mode"].'.txt';
	//更新
	if(@regist($_POST[$_POST["mode"]], $filename)){
		header("Location: ".basename($sn)."?set=1&set_no=".$_GET["set_no"]);
		exit;
	}else{
		header("Location: ".basename($sn)."?set=2&set_no=".$_GET["set_no"]);
		exit;
	}
}

/*=========================================*/
/* プラグイン読み込み                      */
/*=========================================*/
$settting["plugin"] = array();
$settting["plugin"] = getfilelist($plugindir);
if(is_array($settting["plugin"])){
	foreach($settting["plugin"] as $k => $v){
		if(!@mb_eregi("(\.php)$", $v)){
			unset($settting["plugin"][$k]);
			continue;
		}
		$settting["plugin"][$k] = basename($v,".php");
	}
	sort($settting["plugin"]);
}

/*=========================================*/
/* スキン読み込み                          */
/*=========================================*/
$settting["skin"] = array();
$settting["skin"] = getfilelist($skindir);
sort($settting["skin"]);

/*=========================================*/
/* 設定初期化                              */
/*=========================================*/
$settting["exclude_hosts"] = array();
$settting["exclude_urls"] = array();
$settting["exclude_uas"] = array();
$settting["act"] = array();
$settting["ch_url"] = array();

/*=========================================*/
/* 各設定読み込み                          */
/*=========================================*/
//HOST・IP
$list_fn = $datadir."exclude_hosts.txt";
if(file_exists($list_fn)) $settting["exclude_hosts"] = setting_read($list_fn);
unset($list_fn);
//URL
$list_fn = $datadir."exclude_urls.txt";
if(file_exists($list_fn)) $settting["exclude_urls"] = setting_read($list_fn);
unset($list_fn);
//UserAgent
$list_fn = $datadir."exclude_uas.txt";
if(file_exists($list_fn)) $settting["exclude_uas"] = setting_read($list_fn);
unset($list_fn);
//act
$list_fn = $datadir."act.txt";
if(file_exists($list_fn)) $settting["act"] = setting_read($list_fn);
unset($list_fn);
//ch_url
$list_fn = $datadir."ch_url.txt";
if(file_exists($list_fn)) $settting["ch_url"] = setting_read($list_fn);
unset($list_fn);
/*=========================================*/
/* データ更新結果                          */
/*=========================================*/
$set_msg = "";
if(isset($_GET["set"])){
	$set_msg = '<br><div id="error">更新結果：&nbsp;';
	switch ($_GET["set"]) {
	case "1":
	    $set_msg .= "正常に更新しました。";
		break;
	case "2":
	    $set_msg .= "更新に失敗しました。";
		break;
	}
	$set_msg .= '</div>';
}
$w3a["DATA_VIEW"] = null;
switch (isset($_GET["set_no"]) ? $_GET["set_no"] : 0) {
	case "1":
		//初期アクション
		$w3a["DATA_ACCESS"] = '初期アクションの設定';

		$w3a["DATA_VIEW"] .= '<table>'
				.'<tr><th>初期アクション</th></tr>'
				.'<tr><td>';

		$w3a["DATA_VIEW"] .= '<form action="'.basename($sn).'?set_no='.$_GET["set_no"].'" method="POST" onSubmit="return check_set()">';
		$w3a["DATA_VIEW"] .= '<input type="hidden" name="mode" value="def_act">';
		$w3a["DATA_VIEW"] .= '<select name="def_act">';
		if($tmp_act = @file($datadir."def_act.txt")){
			$act = trim($tmp_act[0]);
			$w3a["DATA_VIEW"] .= '<option value="'.$act.'">'.$act.'</option>';
			$w3a["DATA_VIEW"] .= '<option value="'.$act.'">----------</option>';
		}
		foreach($settting["plugin"] as $v){
			$w3a["DATA_VIEW"] .= '<option value="'.$v.'">'.$v.'</option>';
		}
		$w3a["DATA_VIEW"] .= '</select>';
		$w3a["DATA_VIEW"] .= '&nbsp;<input type="submit" value="　　　更新　　　">';
		$w3a["DATA_VIEW"] .= '</form>';

		$w3a["DATA_VIEW"] .= '</td></tr>'
				.'</table>';
		break;

	case "2":
		//URLタイトル変換リスト
		$w3a["DATA_ACCESS"] = 'URLタイトル変換リスト';

		$w3a["DATA_VIEW"] .= '<table>'
				.'<tr><th>URLタイトル変換リストの追加</th></tr>'
				.'<tr><td class="font_small">'
				.'URL||変換後のタイトル<br>'
				.'「&nbsp;<b>||</b>&nbsp;」で区切る'
				.'</td></tr>'
				.'<tr><td>';

		$w3a["DATA_VIEW"] .= '<form action="'.basename($sn).'?set_no='.$_GET["set_no"].'" method="POST" onSubmit="return check_set()">';
		$w3a["DATA_VIEW"] .= '<input type="hidden" name="mode" value="ch_url">';
		$w3a["DATA_VIEW"] .= '<textarea name="ch_url" cols="70" rows="30" wrap="OFF">';
		if($settting["ch_url"]){
			foreach($settting["ch_url"] as $v){
				$w3a["DATA_VIEW"] .= $v."\n";
			}
		}
		$w3a["DATA_VIEW"] .= '</textarea>';
		$w3a["DATA_VIEW"] .= '<br><input type="submit" value="　　　更新　　　">&nbsp;<input type="reset" value="リセット">';
		$w3a["DATA_VIEW"] .= '</form>';

		$w3a["DATA_VIEW"] .= '</td></tr>'
				.'</table>';
		break;
	case "3":
		//拒否リスト
		$w3a["DATA_ACCESS"] = '拒否リスト';
		//HOST・IP
		$w3a["DATA_VIEW"] .= '<table>'
				.'<tr><th>拒否 HOST・IP</th></tr>'
				.'<tr><td>'
				.'<form action="'.basename($sn).'?set_no='.$_GET["set_no"].'" method="POST" onSubmit="return check_set()">'
				.'<input type="hidden" name="mode" value="exclude_hosts">'
				.'<textarea name="exclude_hosts" cols="70" rows="10" wrap="OFF">';
		if($settting["exclude_hosts"]){
			foreach($settting["exclude_hosts"] as $v){
				$w3a["DATA_VIEW"] .= $v."\n";
			}
		}
		$w3a["DATA_VIEW"] .= '</textarea>'
				.'<br><input type="submit" value="　　　更新　　　">&nbsp;<input type="reset" value="リセット">'
				.'</form>'
				.'</td></tr>'
				.'</table><br>';
		//URL
		$w3a["DATA_VIEW"] .= '<table>'
				.'<tr><th>拒否 URL</th></tr>'
				.'<tr><td>'
				.'<form action="'.basename($sn).'?set_no='.$_GET["set_no"].'" method="POST" onSubmit="return check_set()">'
				.'<input type="hidden" name="mode" value="exclude_urls">'
				.'<textarea name="exclude_urls" cols="70" rows="10" wrap="OFF">';
		if($settting["exclude_urls"]){
			foreach($settting["exclude_urls"] as $v){
				$w3a["DATA_VIEW"] .= $v."\n";
			}
		}
		$w3a["DATA_VIEW"] .= '</textarea>'
				.'<br><input type="submit" value="　　　更新　　　">&nbsp;<input type="reset" value="リセット">'
				.'</form>'
				.'</td></tr>'
				.'</table><br>';
		//UserAgent
		$w3a["DATA_VIEW"] .= '<table>'
				.'<tr><th>拒否 UserAgent</th></tr>'
				.'<tr><td>'
				.'<form action="'.basename($sn).'?set_no='.$_GET["set_no"].'" method="POST" onSubmit="return check_set()">'
				.'<input type="hidden" name="mode" value="exclude_uas">'
				.'<textarea name="exclude_uas" cols="70" rows="10" wrap="OFF">';
		if($settting["exclude_uas"]){
			foreach($settting["exclude_uas"] as $v){
				$w3a["DATA_VIEW"] .= $v."\n";
			}
		}
		$w3a["DATA_VIEW"] .= '</textarea>'
				.'<br><input type="submit" value="　　　更新　　　">&nbsp;<input type="reset" value="リセット">'
				.'</form>'
				.'</td></tr>'
				.'</table>';
		break;
	case "4":
		//メニューリストの設定
		$w3a["DATA_ACCESS"] = 'メニューリストの設定';

		$w3a["DATA_VIEW"] .= '<table>'
				.'<tr><th colspan="2">トップ項目の追加</th></tr>'
				.'<tr><td colspan="2" class="font_small">'
				.'[トップ項目名]<br>'
				.'「&nbsp;<b>[</b>&nbsp;」と「&nbsp;<b>]</b>&nbsp;」で囲む'
				.'</td></tr>'
				.'<tr><th colspan="2">アクションの追加</th></tr>'
				.'<tr><td colspan="2" class="font_small">'
				.'アクション||表示名<br>'
				.'「&nbsp;<b>||</b>&nbsp;」で区切る'
				.'</td></tr>'
				.'<tr valign="top">'
				.'<td>'
				.'<form action="'.basename($sn).'?set_no='.$_GET["set_no"].'" method="POST" onSubmit="return check_set()">'
				.'<input type="hidden" name="mode" value="act">'
				.'<textarea name="act" cols="40" rows="20" wrap="OFF">';
		if($settting["act"]){
			foreach($settting["act"] as $v){
				/*if(function_exists('mb_convert_encoding')){
					$v = @mb_convert_encoding($v, "eucJP-win" , "ISO-2022-JP-MS,eucJP-win,UTF-8,SJIS-win");
				}else{
					$v = jcode_convert_encoding($v,'euc-jp');
				}*/
				$w3a["DATA_VIEW"] .= $v."\n";
			}
		}
		$w3a["DATA_VIEW"] .= '</textarea>'
				.'<br><input type="submit" value="　　　更新　　　">&nbsp;<input type="reset" value="リセット">'
				.'</form>'
				.'</td>'
				.'<td>'
				.'<b>【&nbsp;アクション一覧&nbsp;】</b><hr>';
		foreach($settting["plugin"] as $v){
			$w3a["DATA_VIEW"] .= '<li>'.$v.'</li>';
		}
		$w3a["DATA_VIEW"] .= '</td>'
				.'</tr></table>';
		break;
	case "5":
		//スキン選択
		$w3a["DATA_ACCESS"] = 'スキン選択';

		$w3a["DATA_VIEW"] .= '<table>'
				.'<tr><th>スキン選択</th></tr>'
				.'<tr><td>';

		$w3a["DATA_VIEW"] .= '<form action="'.basename($sn).'?set_no='.$_GET["set_no"].'" method="POST" onSubmit="return check_set()">';
		$w3a["DATA_VIEW"] .= '<input type="hidden" name="mode" value="skin">';
		$w3a["DATA_VIEW"] .= '<select name="skin">';
		if($tmp_skin = @file($datadir."skin.txt")){
			$skin = trim($tmp_skin[0]);
			$w3a["DATA_VIEW"] .= '<option value="'.$skin.'">'.$skin.'</option>';
			$w3a["DATA_VIEW"] .= '<option value="'.$skin.'">----------</option>';
		}
		foreach($settting["skin"] as $v){
			$w3a["DATA_VIEW"] .= '<option value="'.$v.'">'.$v.'</option>';
		}
		$w3a["DATA_VIEW"] .= '</select>';
		$w3a["DATA_VIEW"] .= '&nbsp;<input type="submit" value="　　　更新　　　">';
		$w3a["DATA_VIEW"] .= '</form>';

		$w3a["DATA_VIEW"] .= '</td></tr>'
				.'</table>';
		break;

	default:
		$w3a["DATA_ACCESS"] = '設定変更';
		$w3a["DATA_VIEW"] = '<div id="error">設定メニューから設定する項目を選択して下さい。</div>';
		break;
}
#-------------------------------------------------
#  COPYRIGHT(削除禁止)
#-------------------------------------------------
$w3a["COPYRIGHT"] = '&copy;&nbsp;w3Analyzer&nbsp;'.$version.'&nbsp;<a href="http://fmono.sub.jp/" target="_blank">OSAKA&nbsp;PHP</a>&nbsp;2004-'.date("Y");

#-------------------------------------------------
#  NAVI_LIST
#-------------------------------------------------
$w3a["NAVI_LIST"] = <<<EOM
<ul>
<li class="list_title">設定変更</li>
<li><a href="w3a.php">戻る</a></li>
<li class="list_title">設定メニュー</li>
<li><a href="setting.php?set_no=1">初期アクション</a></li>
<li><a href="setting.php?set_no=2">URLタイトル変換リスト</a></li>
<li><a href="setting.php?set_no=3">拒否リスト</a></li>
<li><a href="setting.php?set_no=4">メニューリスト</a></li>
<li><a href="setting.php?set_no=5">スキン選択</a></li>
</ul>
EOM;

#-------------------------------------------------
#  DATA_ACCESS
#-------------------------------------------------
$w3a["DATA_ACCESS"] = '<div class="title">'.$w3a["DATA_ACCESS"].'</div>'
					.$set_msg;

echo read_skin($skin_file,$w3a);
exit;
?>
