<?php
/************************************************************/
/*                                                          */
/*     ■□■□ w3Analyzerログ取得用スクリプト ■□■□     */
/*                                                          */
/*                               【使い方の詳細は以下URLへ】*/
/*                           http://fmono.sub.jp/howto.html */
/************************************************************/

if(isset($_GET["W3A"])) return;
if(isset($_GET["GET_TITLE"])) return;
if(strpos($_SERVER["QUERY_STRING"],'?GET_TITLE')) return;
if(strpos($_SERVER["QUERY_STRING"],'&GET_TITLE')) return;
if(strpos($_SERVER["QUERY_STRING"],'?W3A')) return;
if(strpos($_SERVER["QUERY_STRING"],'&W3A')) return;
/*==========================================================*/
/* 初期設定                                                 */
/*==========================================================*/
// ホームディレクトリからのw3Analyzerディレクトリパス
$acc_path = 'w3a';

// 解析ページのCHARSETを指定する
define(W3A_ENCODING,"UTF-8,SJIS-win,eucJP-win,ASCII");

/*==========================================================*/
/* 特殊設定                                                 */
/* 特に設定の必要はありませんが、必要に応じて設定して下さい */
/*==========================================================*/
//【リロード対策＆ログ肥大化対策】
// 同一IP/HOSTからの同ページに対してのアクセスを保存しない(秒) 0 => 無効
$w3a_option["unwrite"] = 10;

//【ログ肥大化対策】
// ログ変換 1 => する , 0 => しない
$w3a_option["log_save"] = 1;

//【ログ取得精度の向上対策】
// ホスト名の取得 1 => する , 0 => しない
$w3a_option["ip_ch"] = 1;

//【タイトルの取得】
// 2 => する(http) 1 => する(local) , 0 => しない
$w3a_option["GET_TITLE_MODE"] = 0;

//タイムアウト(分)
$w3a_option["TIME_OUT"] = 30;

/*==========================================================*/
/* 設定ここまで                                             */
/*==========================================================*/

/*======================================*/
/* function                             */
/*======================================*/
//デバッグ
/*
function debug($data){
	print "<XMP>";
	print_r($data);
	print "</XMP>";
	exit;
}
*/
//データ生成
function mk_data_w3a($str){
	$str = str_replace("\t","",$str);
	$str = "\t".$str;

	return $str;
}
//拒否リスト読み込み
function exclude_read($uri){
	if(file_exists($uri)){
		if($arr_exclude = file($uri)){
			$arr_exclude = array_unique($arr_exclude);
			return $arr_exclude;
		}
	}
}
//ログ変換
function log_save_enc($slist,$sval,$sw_break=0){
	if(!$sval) return ;
	foreach ($slist as $k => $v) {
		if(strstr($sval,$v)){
	   		$sval = str_replace ($v, '!'.$k.'!', $sval);
	   		if(!$sw_break) break;
	    }
	}
	return $sval;
}
//配列に指定値があるかチェック
function isValueInArray($str,$arr){
	$retval = FALSE;
	if(is_array($arr)){
		foreach($arr as $v){
			if(stristr(trim($str), trim($v))){
				$retval = TRUE;
				break;
			}
		}
	}
	return $retval;
}
//ROOTDIR
function get_rootdir(){
	global $acc_path;
	$mypath = str_replace('\\','/',dirname(__FILE__));
	return @mb_ereg_replace("(".$acc_path.")$", "", $mypath);
}
function get_indexname($requri){
	$search_path = get_rootdir();
	$retpath = $requri;
	$arr_indexs = array('index.html','index.htm','index.shtml','index.php','index.php4','index.php3','index.cgi','index.pl','index.phtml');
	foreach($arr_indexs as $index){
		if(file_exists($search_path.$requri.$index)){
			$retpath .= $index;
			break;
		}
	}
	return $retpath;
}
//タイトル取得
function get_title($send_title="",$ref_path=""){
	if($send_title){
		$send_title = trim($send_title);
		$send_title = w3a_convert_encoding($send_title);
		return $send_title;
	}
	global $w3a_option,$acc_path;
	if($w3a_option["GET_TITLE_MODE"] == 0) return;
	$title = '';
	$url = null;
	if($w3a_option["GET_TITLE_MODE"] == 1){
		$search_path = get_rootdir();
		$createurl = $ref_path;
		if(strpos($createurl,'?') !== false) $createurl = preg_replace('/\?.+/','',$createurl);
		//URL右端が/なら
		if(substr($createurl,-1,1) == '/'){
			$url = $search_path.get_indexname($createurl);
		}else{
			$url = $search_path.$createurl;
		}
		if($url=='') return;
		if(strpos($url,':')===false) $url = str_replace(array('//','\\\\'),array('/','/'),$url);
	}else if($w3a_option["GET_TITLE_MODE"] == 2){
		//無効
		if(!$ref_path || !ini_get('allow_url_fopen')) return "";

		$url = "http://".$_SERVER["HTTP_HOST"].$ref_path;

		if($_SERVER["QUERY_STRING"]){
			$url .= "?".$_SERVER["QUERY_STRING"]."&W3A=";
		}else{
			$url .= "?W3A=";
		}
	}
	if(function_exists('file_get_contents')){
		$htmldtl = @file_get_contents($url);
	}else{
		$htmldtl = @implode('',@file($url));
	}
	if($htmldtl){
		$enchtml = w3a_convert_encoding($htmldtl);
		preg_match("/<title[^>]*>([^<]*)<\/title>/i",$enchtml,$ttl);
		if(isset($ttl[1])) $title = w3a_convert_encoding(trim($ttl[1]));
		return $title;
	}
}
/*======================================*/
/* 文字コード変換                       */
/*======================================*/
function w3a_convert_encoding($convstring){
	/*if(function_exists('mb_convert_encoding')){
		$convstring = mb_convert_encoding($convstring,"eucJP-win" , W3A_ENCODING);
	}*/
	return trim($convstring);
}
/*======================================*/
/* w3Analyzerディレクトリパス取得       */
/*======================================*/
if(!isset($_GET["W3A"]) || isset($w3a_send_title)){
	//パス取得
//	if(isset($_GET["ref"])){
//		$path_include = "";
//	}else{
		//w3Analyzerディレクトリパス編集
		$path_include = str_replace('\\','/',dirname(__FILE__)."/");
//	}
	//
	if(@include_once($path_include."inc/config.php")){
		//時差指定無かったらとりあえず日本時間
		if(!isset($time_diff)) $time_diff = 9;
		/*======================================*/
		/* 設定の読み込み等                     */
		/*======================================*/
		if($log_type){
			$w3a_logfile = $path_include.$logdir.$logpref.gmdate("Ymd", time()+$time_diff*3600).$logext;
		}else{
			$w3a_logfdir = $path_include.$logdir.gmdate("Ym", time()+$time_diff*3600);
			if(!is_dir($w3a_logfdir)) mkdir($w3a_logfdir,0777);
			$w3a_logfile = $w3a_logfdir."/".$logpref.gmdate("d", time()+$time_diff*3600).$logext;
		}
		/*======================================*/
		/* 拒否リストの読み込み                 */
		/*======================================*/
		unset($exclude);
		$exclude_fn = $path_include.$datadir."exclude_hosts.txt";
		if(file_exists($exclude_fn)) $exclude["hosts"] = exclude_read($exclude_fn);
		$exclude_fn = $path_include.$datadir."exclude_urls.txt";
		if(file_exists($exclude_fn)) $exclude["urls"] = exclude_read($exclude_fn);
		$exclude_fn = $path_include.$datadir."exclude_uas.txt";
		if(file_exists($exclude_fn)) $exclude["uas"] = exclude_read($exclude_fn);
		unset($exclude_fn);
		/*======================================*/
		/* メイン処理                           */
		/*======================================*/
		//バッファ初期化
		$w3a_buf = array();

		$w3a_buf["path"] = null;
		$w3a_buf["host"] = null;
		$w3a_buf["ref"] = null;
		$w3a_buf["ua"] = null;
		$w3a_buf["title"] = null;
		$w3a_buf["id"] = null;
		$w3a_buf["vc"] = null;
		//HOSTの設定
		$w3a_buf["host"] = ($w3a_option["ip_ch"] ? gethostbyaddr($_SERVER["REMOTE_ADDR"]) : $_SERVER["REMOTE_ADDR"]);

		$write_flg = true;
		//除外処理
		if(isValueInArray($w3a_buf["host"],$exclude["hosts"])) $write_flg = false;
		if(isset($_SERVER["REMOTE_ADDR"])) if(isValueInArray($_SERVER["REMOTE_ADDR"],$exclude["hosts"])) $write_flg = false;
		if(isset($_SERVER["HTTP_REFERER"])) if(isValueInArray($_SERVER["HTTP_REFERER"],$exclude["urls"])) $write_flg = false;
		if(isset($_SERVER["HTTP_USER_AGENT"])) if(isValueInArray($_SERVER["HTTP_USER_AGENT"],$exclude["uas"])) $write_flg = false;

		//パスとリファラーの設定
		if(isset($_GET["ref"])){
			$w3a_buf["path"] = isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : '';
			$w3a_buf["path"] = @mb_ereg_replace("(https?|ftp|news)(://[[:alnum:]\+\$\;\?\.%,!#~*:@&=_-]+)(/.*)","\\3",$w3a_buf["path"]);
			//リファラー編集
			$w3a_buf["ref"] = w3a_convert_encoding(urldecode($_GET["ref"]));
			if(count($_GET) > 1){
				foreach($_GET as $k => $v){
					if($k == "ref" || $k == "W3A" || $k == "pttl") continue;
					$w3a_buf["ref"] .= '&'.$k;
					if($v != "") $w3a_buf["ref"] .= '='.urlencode($v);
				}
			}
			//パス編集
			$w3a_buf["path"] = str_replace('?ref','',$w3a_buf["path"]);
		}else{
			if(isset($_SERVER["REQUEST_URI"])){
				$w3a_buf["path"] = $_SERVER["REQUEST_URI"];
				if(substr($w3a_buf["path"],-1,1) == '/'){
					$w3a_buf["path"] = get_indexname($w3a_buf["path"]);
				}
			}else{
				$w3a_buf["path"] = $_SERVER["SCRIPT_NAME"];
				//クエリ
				if($_SERVER["QUERY_STRING"]) $w3a_buf["path"] .= "?".$_SERVER["QUERY_STRING"];
			}
			$w3a_buf["ref"] = isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : '';
		}
		//ユーザーエージェントの設定
		$w3a_buf["ua"] = $_SERVER["HTTP_USER_AGENT"];

		//title
		if(isset($_GET["pttl"])){
			$w3a_buf["title"] = w3a_convert_encoding(urldecode($_GET["pttl"]));
		}else{
			if(!isset($w3a_send_title)) $w3a_send_title = '';
			$w3a_buf["title"] = get_title($w3a_send_title,$w3a_buf["path"]);
		}
		//ID
		if(isset($_COOKIE["w3"]["id"])){
			$w3a_buf["id"] = $_COOKIE["w3"]["id"];
		}else{
			foreach(explode(".",$_SERVER["REMOTE_ADDR"]) as $v){ $w3a_buf["id"] .= sprintf("%x",abs(intval($v))); }
		}
		switch( true ){
	    case (isset( $_SERVER['HTTP_X_DCMGUID'] )): // iModeかどうか
	        $w3a_buf["id"] = $_SERVER['HTTP_X_DCMGUID'];
		    break;
	    case (isset( $_SERVER['HTTP_X_UP_SUBNO'] )): // ezweb
	        $w3a_buf["id"] = $_SERVER['HTTP_X_UP_SUBNO'];
	        break;
	    case (isset($_SERVER['HTTP_X_JPHONE_UID'] )): //Softbank
	        $w3a_buf["id"] = $_SERVER['HTTP_X_JPHONE_UID'];
	        break;
	    case (isset($_SERVER['HTTP_X_EM_UID'] )): //Emobile
	        $w3a_buf["id"] = $_SERVER['HTTP_X_EM_UID'];
	        break;
	    case (strpos($_SERVER['HTTP_USER_AGENT'],'DoCoMo/2.0') !== false): // Docomo Fomaかどうか
	        preg_match("/.+;(icc[0-9]+)[F|f]?\)/",$_SERVER['HTTP_USER_AGENT'], $matches);
	        if(isset($matches[1])) $w3a_buf["id"] = 'df:'.$matches[1];
	        break;
	    case (strpos($_SERVER['HTTP_USER_AGENT'],'DoCoMo/1.0') !== false): // Docomo Movaかどうか
	        preg_match("/DoCoMo\/1\.0\/.+\/(ser.+)/",$_SERVER['HTTP_USER_AGENT'], $matches);
			if(isset($matches[1])) $w3a_buf["id"] = 'dm:'.$matches[1];
	        break;
	    default:
	        break;
		}
		@setcookie("w3[id]",$w3a_buf["id"],time()+60*60*24*30,'/');

		//vc (タイムアウト以内はカウントアップしない)
		$w3a_buf["vc"] = '';
		if(isset($_COOKIE["w3"]["date"])){
			if($_COOKIE["w3"]["date"] < time()-$w3a_option["TIME_OUT"]*60){
				$w3a_buf["vc"] = isset($_COOKIE["w3"]["vc"]) ? ++$_COOKIE["w3"]["vc"] : 1;
				@setcookie("w3[vc]",$w3a_buf["vc"],time()+60*60*24*30,'/');
			}else{
				$w3a_buf["vc"] = isset($_COOKIE["w3"]["vc"]) ? $_COOKIE["w3"]["vc"] : 1;
			}
		}else{
			$w3a_buf["vc"] = isset($_COOKIE["w3"]["vc"]) ? $_COOKIE["w3"]["vc"] : 1;
			@setcookie("w3[vc]",$w3a_buf["vc"],time()+60*60*24*30,'/');
		}
		//最新訪問時間
		@setcookie("w3[date]",time(),time()+60*60*24*30,'/');

		// http://カット
		if(strpos($w3a_buf["ref"], 'http://') === 0) $w3a_buf["ref"] = str_replace ('http://', "", $w3a_buf["ref"]);
		if(strpos($w3a_buf["ref"], $_SERVER["HTTP_HOST"]) === 0) $w3a_buf["ref"] = "[m]".str_replace ($_SERVER["HTTP_HOST"], "", $w3a_buf["ref"]);

		//ログ変換(肥大化抑制)
		if($w3a_option["log_save"]){
			unset($log_save);
			$log_save_fn = $path_include."inc/save_list.php";
			if(file_exists($log_save_fn)){
				include_once($log_save_fn);
				$w3a_buf["ref"] = log_save_enc($log_save["ref"],$w3a_buf["ref"]);
				$w3a_buf["host"] = log_save_enc($log_save["host"],$w3a_buf["host"]);
				$w3a_buf["ua"] = log_save_enc($log_save["ua"],$w3a_buf["ua"],1);
			}
		}

		//追加モードで開く
		if($write_flg && $fn = fopen($w3a_logfile,"a+b")){
			//リロード対策
			if($w3a_option["unwrite"]){
				rewind($fn);
				while (!feof($fn)) {
					$str = trim(fgets($fn));
					if($str == "") continue;
					list($tmp_data["dt"],$tmp_data["path"],$tmp_data["host"],) = explode("\t",$str);
					if($tmp_data["dt"]) list($tmp_data["day"],$tmp_data["week"],$tmp_data["hour"],$tmp_data["minute"],$tmp_data["sec"]) = explode(",",$tmp_data["dt"]);
					//TIME
					$write_time = time()-mktime($tmp_data["hour"],$tmp_data["minute"],$tmp_data["sec"]);
					//指定秒以上なら終了
					if($w3a_option["unwrite"] < $write_time){ unset($tmp_data,$write_time); continue; }
					//PATH/HOSTチェック
					if($tmp_data["path"] == $w3a_buf["path"] && $w3a_buf["host"] == $tmp_data["host"]){
						$write_flg = false;
						unset($tmp_data,$write_time);
						break;
					}
				}
			}
			//書き込み
			if($write_flg){
				//書き込みバッファ0に PHP4.3以上
				if(function_exists('stream_set_write_buffer')) stream_set_write_buffer($fn, 0);
				//ファイルロック
				flock($fn,LOCK_EX);
				fwrite($fn,gmdate("d,D,H,i,s", time()+$time_diff*3600));
				fwrite($fn,mk_data_w3a($w3a_buf["path"]));
				fwrite($fn,mk_data_w3a($w3a_buf["host"]));
				fwrite($fn,mk_data_w3a($w3a_buf["ref"]));
				fwrite($fn,mk_data_w3a($w3a_buf["ua"]));
				fwrite($fn,mk_data_w3a($w3a_buf["title"]));
				fwrite($fn,mk_data_w3a($w3a_buf["id"]));
				fwrite($fn,mk_data_w3a($w3a_buf["vc"]));
				fwrite($fn,"\n");
				//ロック解除
				flock($fn,LOCK_UN);
			}
			fclose($fn);
		}
		unset($w3a_buf,$w3a_logfile);
	}
	unset($path_include,$w3a_option);
}
/*======================================*/
/* HTML用(1X1透明画像出力)              */
/*======================================*/
if(isset($_GET["ref"])){
	header("Content-Type: image/gif");
	echo base64_decode("R0lGODlhAQABAIAAAP///wAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==");
}
?>